/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.element.impl;

import java.io.File;
import org.apache.commons.fileupload.FileItem;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.impl.SingleValue;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.element.Element;
import uk.ac.nesc.rapid.util.StringUtil;

public class FileUploadElement
extends Element {
    private int size = 10;
    private String destination = null;
    private String fileUploadName = "";

    public FileUploadElement() {
        this.setReadOnly(false);
    }

    public Value get(Job job) throws RapidException {
        return new SingleValue(job.getFileUpload(this.fileUploadName));
    }

    public void put(Job job, FileItem item) throws RapidException {
        if (this.isReadOnly()) {
            return;
        }
        if (item.isFormField()) {
            throw new RapidException("Item " + item.getFieldName() + " is not a File at element " + this.getName());
        }
        if (!"".equals(item.getName())) {
            job.setFileUpload(this.fileUploadName, item.getName());
            String resolvedDestination = StringUtil.insertVariables(this.destination, 0, job);
            File uploadedFile = new File(resolvedDestination);
            try {
                item.write(uploadedFile);
            }
            catch (Exception ex) {
                throw new RapidException("Unable to write file to " + this.getDestination() + " : " + ex.getMessage());
            }
        }
    }

    public void put(Job job, Value value) throws RapidException {
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getFileUploadName() {
        return this.fileUploadName;
    }

    public void setFileUploadName(String fileUploadName) {
        this.fileUploadName = fileUploadName;
    }

    public void setAction(String action) {
        this.setReadOnly("output".equalsIgnoreCase(action));
    }

    public String toString() {
        String result = "";
        result = result + "File upload\n";
        result = result + super.toString();
        result = result + " size: " + this.getSize() + "\n";
        result = result + " destination " + this.getDestination() + "\n";
        result = result + " file upload " + this.getFileUploadName() + "\n";
        return result;
    }
}

