/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.element.impl;

import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.job.DataStage;
import uk.ac.nesc.rapid.data.job.DataStageURL;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.data.job.StageType;
import uk.ac.nesc.rapid.element.Element;

public class FileSystemElement
extends Element {
    private String dataStageName = null;
    private StageType stageType = StageType.SOURCE;

    public Value get(Job job) throws RapidException {
        DataStageURL dataStageURL;
        DataStage dataStage = job.getDataStage(this.getDataStageName());
        try {
            dataStageURL = dataStage.getURL(this.stageType);
        }
        catch (RapidException ex) {
            throw new RapidException("At datastafe '" + this.getDataStageName() + "'" + ex.getMessage());
        }
        return dataStageURL.getFileSystem();
    }

    public void put(Job job, Value value) throws RapidException {
        if (this.isReadOnly() || value.get().equals("")) {
            return;
        }
        DataStage dataStage = job.getDataStage(this.getDataStageName());
        dataStage.getURL(this.stageType).setFileSystem(value);
    }

    public String getDataStageName() {
        return this.dataStageName;
    }

    public void setDataStageName(String dataStageName) {
        this.dataStageName = dataStageName;
    }

    public StageType getStageType() {
        return this.stageType;
    }

    public void setStageType(StageType stageType) {
        this.stageType = stageType;
    }

    public void setStageType(String stageType) {
        this.stageType = StageType.parseString(stageType);
    }

    public static String getPattern() {
        return "datastage/filesystem";
    }

    public String toString() {
        String result = "";
        result = result + "FileSystem\n";
        result = result + super.toString();
        result = result + " DataStage: " + this.getDataStageName() + "\n";
        result = result + " Type: " + (Object)((Object)this.stageType) + "\n";
        return result;
    }
}

