/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.job.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.impl.JobIDValue;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.data.job.JobTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobTableImpl
implements JobTable,
Comparator<Job> {
    Map<String, Job> jobTable = new TreeMap<String, Job>();
    Job currentJob = null;

    @Override
    public Job getJob() {
        return this.currentJob;
    }

    @Override
    public Job getJob(String id) throws RapidException {
        Job result = this.jobTable.get(id);
        if (result == null) {
            throw new RapidException("No job with ID " + id + "in Job table.");
        }
        return result;
    }

    @Override
    public void deleteJob(String id) throws RapidException {
        if (this.jobTable.remove(id) == null) {
            throw new RapidException("Could not remove job with id " + id + " because it does not exist!");
        }
    }

    @Override
    public void addJob(Job newJob) throws RapidException {
        if (this.currentJob != null) {
            Value jobID = this.currentJob.getJobID();
            if (jobID == null) {
                throw new RapidException("Submit job BEFORE adding a new one to the table!");
            }
            this.jobTable.put(JobIDValue.getJobID(jobID), this.currentJob);
        }
        this.currentJob = newJob;
    }

    @Override
    public int size() {
        return this.jobTable.values().size();
    }

    @Override
    public List<Job> getJobList() {
        Collection<Job> jobCollection = this.jobTable.values();
        Vector<Job> jobList = new Vector<Job>(new HashSet<Job>(jobCollection));
        Collections.sort(jobList, this);
        return jobList;
    }

    @Override
    public int compare(Job job0, Job job1) {
        return job1.getDate().compareTo(job0.getDate());
    }

    @Override
    public boolean exists(String id) {
        return this.jobTable.containsKey(id);
    }
}

