/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.job.impl;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.filesystem.security.AuthIndex;
import uk.ac.nesc.rapid.data.filesystem.security.Authentication;
import uk.ac.nesc.rapid.data.impl.ArrayValue;
import uk.ac.nesc.rapid.data.impl.EmptyValue;
import uk.ac.nesc.rapid.data.impl.JobIDValue;
import uk.ac.nesc.rapid.data.job.DataStage;
import uk.ac.nesc.rapid.data.job.EnvironmentVariable;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.data.job.StageType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobImpl
implements Job {
    private Value jobid = new ArrayValue();
    private Value executable = new EmptyValue();
    private Value stdin = new EmptyValue();
    private Value stdout = new EmptyValue();
    private Value stderr = new EmptyValue();
    private Value workingDir = new EmptyValue();
    private Value submissionServer = new EmptyValue();
    private Date date = new Date();
    private List<Value> parameterList = new Vector<Value>();
    private Map<Integer, EnvironmentVariable> environmentMap = new HashMap<Integer, EnvironmentVariable>();
    private Map<String, DataStage> datastageMap = new HashMap<String, DataStage>();
    private Map<String, Value> localVariableMap = new HashMap<String, Value>();
    private Map<String, String> fileUploadMap = new HashMap<String, String>();
    private Map<AuthIndex, Authentication> authenticationMap = new HashMap<AuthIndex, Authentication>();
    private int numberOfSubJobs = 0;

    @Override
    public Value getVariable(String name) {
        return this.localVariableMap.get(name);
    }

    @Override
    public void setVariable(String name, Value value) {
        this.localVariableMap.put(name, value);
    }

    @Override
    public Value getJobID() {
        return this.jobid;
    }

    @Override
    public void setJobID(Value jobID) {
        this.jobid = jobID;
    }

    @Override
    public Value getExecutable() {
        return this.executable;
    }

    @Override
    public void setExecutable(Value executable) {
        this.executable = executable;
    }

    @Override
    public Value getStdin() {
        return this.stdin;
    }

    @Override
    public void setStdin(Value stdin) {
        this.stdin = stdin;
    }

    @Override
    public Value getStdout() {
        return this.stdout;
    }

    @Override
    public void setStdout(Value stdout) {
        this.stdout = stdout;
    }

    @Override
    public Value getStderr() {
        return this.stderr;
    }

    @Override
    public void setStderr(Value stderr) {
        this.stderr = stderr;
    }

    @Override
    public Value getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDir(Value workingdir) {
        this.workingDir = workingdir;
    }

    @Override
    public Value getParameter(int index) throws RapidException {
        if (index >= 0 && index < this.parameterList.size()) {
            return this.parameterList.get(index);
        }
        throw new RapidException("No parameter with index " + index + " maximum parameters: " + this.parameterList.size());
    }

    @Override
    public List<Value> getParameterList() {
        return this.parameterList;
    }

    @Override
    public void addParameter(Value parameter) {
        this.parameterList.add(parameter);
    }

    @Override
    public void addParameter(int index, Value parameter) {
        if (parameter == null) {
            return;
        }
        while (index >= this.parameterList.size()) {
            this.parameterList.add(new EmptyValue());
        }
        this.parameterList.remove(index);
        this.parameterList.add(index, parameter);
    }

    @Override
    public EnvironmentVariable getEnvironmentVariable(int index) throws RapidException {
        EnvironmentVariable result = this.environmentMap.get(index);
        if (result == null) {
            throw new RapidException("Index out of range for environment variable. Index: " + index);
        }
        return result;
    }

    @Override
    public Collection<EnvironmentVariable> getEnvironmentVariableCollection() {
        return this.environmentMap.values();
    }

    @Override
    public void addEnvironmentName(int index, Value name) {
        if (name == null) {
            return;
        }
        EnvironmentVariable env = this.environmentMap.get(index);
        if (env == null) {
            env = new EnvironmentVariable();
        }
        env.setName(name);
        this.addEnvironmentVariable(index, env);
    }

    @Override
    public void addEnvironmentValue(int index, Value value) {
        if (value == null) {
            return;
        }
        EnvironmentVariable env = this.environmentMap.get(index);
        if (env == null) {
            env = new EnvironmentVariable();
        }
        env.setValue(value);
        this.addEnvironmentVariable(index, env);
    }

    @Override
    public void addEnvironmentVariable(int index, EnvironmentVariable environment) {
        this.environmentMap.put(index, environment);
    }

    @Override
    public void addDataStage(String name, DataStage datastage) {
        this.datastageMap.put(name, datastage);
    }

    @Override
    public boolean existsDataStage(String name) {
        return null != this.datastageMap.get(name);
    }

    @Override
    public DataStage getDataStage(String name) throws RapidException {
        DataStage result = this.datastageMap.get(name);
        if (result == null) {
            throw new RapidException("No DataStage found with name '" + name + "'");
        }
        return result;
    }

    @Override
    public Set<String> getDataStages() {
        return this.datastageMap.keySet();
    }

    @Override
    public Value getSubmissionServer() {
        return this.submissionServer;
    }

    @Override
    public void setSubmissionServer(Value submissionServer) {
        this.submissionServer = submissionServer;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public void setFileUpload(String name, String fileName) {
        this.fileUploadMap.put(name, fileName);
    }

    @Override
    public String getFileUpload(String name) {
        String result = this.fileUploadMap.get(name);
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public void addAuthentication(String fileSystemName, String dataStageName, StageType type, Authentication auth) {
        this.authenticationMap.put(new AuthIndex(fileSystemName, dataStageName, type), auth);
    }

    @Override
    public Authentication getAuthentication(String fileSystemName, String dataStageName, StageType type) {
        Authentication result = this.getAuthentication(dataStageName, type);
        if (result == null) {
            result = this.getAuthentication(fileSystemName);
        }
        return result;
    }

    @Override
    public Authentication getAuthentication(String fileSystemName) {
        return fileSystemName == null ? null : this.authenticationMap.get(new AuthIndex(fileSystemName, null, null));
    }

    @Override
    public Authentication getAuthentication(String dataStageName, StageType type) {
        return dataStageName == null || type == null ? null : this.authenticationMap.get(new AuthIndex(null, dataStageName, type));
    }

    public String toString() {
        int i;
        String result = "JOB REPOSITORY:\n=====================\n";
        result = result + "ID: " + this.jobid.toString() + "\n";
        result = result + "EXEC: " + this.executable + "\n";
        result = result + "STDIN: " + this.stdin + "\n";
        result = result + "STDOUT: " + this.stdout + "\n";
        result = result + "STDERR: " + this.stderr + "\n";
        result = result + "WDIR: " + this.workingDir + "\n";
        result = result + "Submision Server " + this.getSubmissionServer() + "\n";
        result = result + "Parameters: ";
        for (i = 0; i < this.parameterList.size(); ++i) {
            result = result + this.parameterList.get(i) + " : ";
        }
        result = result + "\n";
        result = result + "Environment Vars: ";
        for (i = 0; i < this.environmentMap.size(); ++i) {
            result = result + this.environmentMap.get(i);
        }
        result = result + "\n";
        result = result + "DataStage:\n";
        Set<String> keyset = this.datastageMap.keySet();
        for (String key : keyset) {
            DataStage ds = this.datastageMap.get(key);
            result = result + "----------------------------\n";
            result = result + "DataStage: " + key + "\n";
            result = result + ds.toString();
        }
        result = result + "----------------------------\n";
        return result;
    }

    @Override
    public int getNumberOfSubJobs() {
        return this.numberOfSubJobs;
    }

    @Override
    public void finalise() throws RapidException {
        this.numberOfSubJobs = Math.max(this.getStderr().size(), this.numberOfSubJobs);
        this.numberOfSubJobs = Math.max(this.getStdin().size(), this.numberOfSubJobs);
        this.numberOfSubJobs = Math.max(this.getStdout().size(), this.numberOfSubJobs);
        this.numberOfSubJobs = Math.max(this.getExecutable().size(), this.numberOfSubJobs);
        this.numberOfSubJobs = Math.max(this.getWorkingDir().size(), this.numberOfSubJobs);
        this.numberOfSubJobs = Math.max(this.getSubmissionServer().size(), this.numberOfSubJobs);
        for (EnvironmentVariable env : this.getEnvironmentVariableCollection()) {
            this.numberOfSubJobs = Math.max(env.getName().size(), this.numberOfSubJobs);
            this.numberOfSubJobs = Math.max(env.getValue().size(), this.numberOfSubJobs);
        }
        for (Value parameter : this.getParameterList()) {
            this.numberOfSubJobs = Math.max(parameter.size(), this.numberOfSubJobs);
        }
        this.getStderr().finalise(this);
        this.getStdin().finalise(this);
        this.getStdout().finalise(this);
        this.getExecutable().finalise(this);
        this.getWorkingDir().finalise(this);
        this.getSubmissionServer().finalise(this);
        for (EnvironmentVariable env : this.getEnvironmentVariableCollection()) {
            env.getName().finalise(this);
            env.getValue().finalise(this);
        }
        for (Value parameter : this.getParameterList()) {
            parameter.finalise(this);
        }
        for (DataStage dataStage : this.datastageMap.values()) {
            dataStage.getFileName().finalise(this);
            if (dataStage.existsSourceURL()) {
                dataStage.getSourceURL().getFileSystem().finalise(this);
                dataStage.getSourceURL().getPath().finalise(this);
            }
            if (!dataStage.existsTargetURL()) continue;
            dataStage.getTargetURL().getFileSystem().finalise(this);
            dataStage.getTargetURL().getPath().finalise(this);
        }
        this.setJobID(new JobIDValue(this.numberOfSubJobs));
        this.setDate(Calendar.getInstance().getTime());
    }
}

