/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.job.impl;

import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.impl.EmptyValue;
import uk.ac.nesc.rapid.data.impl.SingleValue;
import uk.ac.nesc.rapid.data.job.CreationFlag;
import uk.ac.nesc.rapid.data.job.DataStage;
import uk.ac.nesc.rapid.data.job.DataStageURL;
import uk.ac.nesc.rapid.data.job.StageType;

public class DataStageImpl
implements DataStage {
    private DataStageURL targetURL = null;
    private DataStageURL sourceURL = null;
    private Value fileName = new EmptyValue();
    private boolean deleteOnTermination = false;
    private CreationFlag creationFlag = CreationFlag.OVERWRITE;

    public DataStageURL getURL(StageType type) throws RapidException {
        if (type == StageType.SOURCE) {
            return this.getSourceURL();
        }
        return this.getTargetURL();
    }

    public void setURL(DataStageURL url, StageType type) {
        if (type == StageType.SOURCE) {
            this.setSourceURL(url);
        } else {
            this.setTargetURL(url);
        }
    }

    public DataStageURL getTargetURL() throws RapidException {
        if (this.targetURL == null) {
            throw new RapidException("No TARGET URL");
        }
        return this.targetURL;
    }

    public void setTargetURL(DataStageURL targetURL) {
        this.targetURL = targetURL;
    }

    public DataStageURL getSourceURL() throws RapidException {
        if (this.sourceURL == null) {
            throw new RapidException("No SOURCE URL");
        }
        return this.sourceURL;
    }

    public void setSourceURL(DataStageURL sourceURL) {
        this.sourceURL = sourceURL;
    }

    public Value getFileName() throws RapidException {
        return this.fileName;
    }

    public void setFileName(Value fileName) {
        this.fileName = fileName;
    }

    public boolean isDeleteOnTermination() {
        return this.deleteOnTermination;
    }

    public void setDeleteOnTermination(boolean deleteOnTermination) {
        this.deleteOnTermination = deleteOnTermination;
    }

    public void setDeleteOnTermination(Value deleteOnTermination) {
        this.deleteOnTermination = deleteOnTermination == null || deleteOnTermination.get() == null || deleteOnTermination.get().toLowerCase().equals("true");
    }

    public CreationFlag getCreationFlagEnum() {
        return this.creationFlag;
    }

    public Value getCreationFlag() {
        return this.creationFlag == null ? null : new SingleValue(this.creationFlag.toString());
    }

    public void setCreationFlag(Value creationFlag) {
        this.creationFlag = CreationFlag.valueOf(creationFlag.get());
    }

    public String toString() {
        String result = "";
        result = result + "Target: \n" + this.targetURL + "\n";
        result = result + "Source: \n" + this.sourceURL + "\n";
        result = result + "Filename: " + this.fileName + "\n";
        result = result + "Creation Flag: " + (Object)((Object)this.creationFlag) + "\n";
        result = result + "DeleteOnTermination " + this.deleteOnTermination + "\n";
        return result;
    }

    public boolean existsURL(StageType type) {
        if (type == StageType.SOURCE) {
            return this.sourceURL != null;
        }
        return this.targetURL != null;
    }

    public boolean existsSourceURL() {
        return this.sourceURL != null;
    }

    public boolean existsTargetURL() {
        return this.targetURL != null;
    }
}

