/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.impl;

import java.util.List;
import java.util.UUID;
import java.util.Vector;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.impl.ArrayValue;
import uk.ac.nesc.rapid.data.impl.BaseValue;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.jsp.ValuePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UUIDValue
extends BaseValue {
    List<String> uuidList = new Vector<String>();

    public UUIDValue() {
        this.uuidList.add(UUID.randomUUID().toString());
    }

    public UUIDValue(int size) {
        for (int i = 0; i < size; ++i) {
            this.uuidList.add(UUID.randomUUID().toString());
        }
    }

    @Override
    public String get() {
        return this.uuidList.get(0);
    }

    @Override
    public String get(int index) {
        if (this.uuidList.size() <= index) {
            for (int i = this.uuidList.size(); i <= index; ++i) {
                this.uuidList.add(UUID.randomUUID().toString());
            }
        }
        return this.uuidList.get(index);
    }

    @Override
    public void put(String value) {
        this.uuidList = new Vector<String>();
        this.uuidList.add(value);
    }

    @Override
    public void put(String[] values) {
        this.uuidList = new Vector<String>();
        for (int i = 0; i < values.length; ++i) {
            this.uuidList.add(UUID.randomUUID().toString());
        }
    }

    @Override
    public void put(List<String> values) {
        this.uuidList = new Vector<String>();
        for (int i = 0; i < values.size(); ++i) {
            this.uuidList.add(UUID.randomUUID().toString());
        }
    }

    @Override
    public String print(ValuePrinter output) {
        ArrayValue value = new ArrayValue(this.uuidList.toArray(new String[0]));
        return output.print(value);
    }

    @Override
    public Value copy() {
        UUIDValue value = new UUIDValue();
        value.put(this.uuidList.toArray(new String[0]));
        return value;
    }

    @Override
    public int size() {
        return this.uuidList.size();
    }

    public String toString() {
        return "UUIDValue " + this.get() + "\n";
    }

    @Override
    public void finalise(Job job) throws RapidException {
        int numberOfSubJobs = job.getNumberOfSubJobs();
        while (this.uuidList.size() < numberOfSubJobs) {
            this.uuidList.add(UUID.randomUUID().toString());
        }
    }
}

