/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.impl;

import java.util.List;
import java.util.UUID;
import java.util.Vector;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.impl.ArrayValue;
import uk.ac.nesc.rapid.data.impl.BaseValue;
import uk.ac.nesc.rapid.jsp.ValuePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobIDValue
extends BaseValue {
    private UUID uuid = UUID.randomUUID();
    private int numberOfSubJobs;
    private static char divider = (char)45;

    public JobIDValue(int numberOfSubJobs) {
        this.numberOfSubJobs = numberOfSubJobs;
    }

    public static String getJobID(Value jobID) throws RapidException {
        return JobIDValue.getJobID(jobID.get());
    }

    public static String getJobID(String jobID) throws RapidException {
        try {
            return jobID.substring(0, 36);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new RapidException("Invalid jobID! '" + jobID + "'");
        }
    }

    public static int getSubJobID(Value jobID) throws RapidException {
        return JobIDValue.getSubJobID(jobID.get());
    }

    public static int getSubJobID(String jobID) throws RapidException {
        try {
            if (jobID.length() == 36) {
                return 0;
            }
            return Integer.parseInt(jobID.substring(37, jobID.length()));
        }
        catch (NumberFormatException ex) {
            throw new RapidException("Invalid subjobID!");
        }
        catch (IndexOutOfBoundsException ex) {
            throw new RapidException("Invalid jobID! '" + jobID + "'");
        }
    }

    @Override
    public String get() {
        return this.get(0);
    }

    @Override
    public String get(int index) {
        int indexToGet = index;
        if (index > this.numberOfSubJobs) {
            indexToGet = this.numberOfSubJobs;
        }
        return this.uuid.toString() + divider + Integer.toString(indexToGet);
    }

    @Override
    public void put(String value) {
        this.numberOfSubJobs = 1;
    }

    @Override
    public void put(String[] values) {
        this.numberOfSubJobs = values.length;
    }

    @Override
    public void put(List<String> values) {
        this.numberOfSubJobs = values.size();
    }

    @Override
    public String print(ValuePrinter output) {
        Vector<String> idList = new Vector<String>();
        for (int i = 0; i < this.numberOfSubJobs; ++i) {
            idList.add(this.get(i));
        }
        return output.print(new ArrayValue(idList));
    }

    @Override
    public int size() {
        return this.numberOfSubJobs;
    }

    public String getUUID() {
        return this.uuid.toString();
    }

    @Override
    public Value copy() {
        return new JobIDValue(this.numberOfSubJobs);
    }
}

