/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.filesystem.security.impl;

import java.util.HashMap;
import java.util.Map;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.filesystem.security.Authentication;

public class AuthenticationImpl
implements Authentication {
    private Map<String, String> authAttributes = new HashMap<String, String>();

    public String getAttribute(String attribute) throws RapidException {
        String value = this.authAttributes.get(attribute);
        return value;
    }

    public boolean exists(String attributes) {
        return this.authAttributes.containsKey(attributes);
    }

    public void setAttribute(String attribute, String value) {
        this.authAttributes.put(attribute, value);
    }

    public int size() {
        return this.authAttributes.size();
    }

    public Authentication clone() {
        AuthenticationImpl newAuth = new AuthenticationImpl();
        for (String auth : this.authAttributes.keySet()) {
            newAuth.setAttribute(auth, this.authAttributes.get(auth));
        }
        return newAuth;
    }

    public boolean equals(Object auth) {
        block5: {
            try {
                if (auth instanceof Authentication) {
                    Authentication castedAuth = (Authentication)auth;
                    if (castedAuth.size() != this.size()) {
                        return false;
                    }
                    for (String att : this.authAttributes.keySet()) {
                        if (castedAuth.exists(att) && this.getAttribute(att).equals(castedAuth.getAttribute(att))) continue;
                        return false;
                    }
                    break block5;
                }
                return false;
            }
            catch (RapidException ex) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.authAttributes != null ? ((Object)this.authAttributes).hashCode() : 0);
        return hash;
    }
}

