/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.filesystem.impl;

import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.globus.myproxy.MyProxy;
import org.globus.myproxy.MyProxyException;
import org.ietf.jgss.GSSCredential;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.security.impl.GSIAuth;
import uk.ac.nesc.rapid.data.filesystem.security.impl.UsernamePasswordAuth;
import uk.ac.nesc.rapid.vfs.gsiftp.GSIFTPFileSystemConfigBuilder;

public class GSIFTPFileSystem
extends AbstractFileSystem {
    private static final int LIFETIME = 99999;
    private GSSCredential proxyCertificate = null;

    public void addVFSOptions(FileSystemOptions opts) throws FileSystemException, MyProxyException, RapidException {
        if (this.getProxyCertificate() == null && this.getMyProxyURL() != null) {
            MyProxy myproxy = new MyProxy();
            myproxy.setHost(this.getMyProxyURL());
            myproxy.setPort(this.getMyProxyPort());
            this.setProxyCertificate(myproxy.get(this.getUsername(), this.getPassword(), 99999));
        }
        if (this.getProxyCertificate() != null) {
            GSIFTPFileSystemConfigBuilder.getInstance().setGSSCredential(opts, this.getProxyCertificate());
        }
    }

    public String getUsername() throws RapidException {
        return UsernamePasswordAuth.getUsername(this.getAuthentication());
    }

    public void setUsername(String username) {
        UsernamePasswordAuth.setUsername(this.getAuthentication(), username);
    }

    public String getPassword() throws RapidException {
        return UsernamePasswordAuth.getPassword(this.getAuthentication());
    }

    public void setPassword(String password) {
        UsernamePasswordAuth.setPassword(this.getAuthentication(), password);
    }

    public String getMyProxyURL() throws RapidException {
        return GSIAuth.getHost(this.getAuthentication());
    }

    public void setMyProxyURL(String myProxyURL) {
        GSIAuth.setHost(this.getAuthentication(), myProxyURL);
    }

    public int getMyProxyPort() throws RapidException {
        int iPort = 7512;
        try {
            String port = GSIAuth.getPort(this.getAuthentication());
            iPort = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return iPort;
    }

    public void setMyProxyPort(int myProxyPort) {
        GSIAuth.setPort(this.getAuthentication(), Integer.toString(myProxyPort));
    }

    public void setMyProxyPort(String myProxyPort) {
        GSIAuth.setPort(this.getAuthentication(), myProxyPort);
    }

    public GSSCredential getProxyCertificate() {
        return this.proxyCertificate;
    }

    public void setProxyCertificate(GSSCredential proxyCertificate) {
        this.proxyCertificate = proxyCertificate;
    }

    public String toString() {
        String result = "";
        result = result + "GSIFTP SERVER\n";
        result = result + "description " + this.getName() + "\n";
        result = result + "URL: " + this.getURL() + "\n";
        try {
            result = result + "myproxyhost: " + this.getMyProxyURL() + "\n";
            result = result + "myproxyport: " + this.getMyProxyPort() + "\n";
            result = result + "username: " + this.getUsername() + "\n";
            result = result + "password: " + this.getPassword() + "\n";
        }
        catch (RapidException ex) {
            result = result + "Invalid authentication parameters: " + ex.getMessage();
        }
        return result;
    }
}

