/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.xml;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import uk.ac.nesc.rapid.data.browser.FileBrowserTable;
import uk.ac.nesc.rapid.data.browser.impl.FileBrowserImpl;
import uk.ac.nesc.rapid.data.browser.impl.FileBrowserTableImpl;
import uk.ac.nesc.rapid.element.impl.PathElement;

public class FileBrowserReader {
    public static FileBrowserTable read(URL xmlFile) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setNamespaceAware(true);
        FileBrowserTableImpl fileBrowserTable = new FileBrowserTableImpl();
        digester.push((Object)fileBrowserTable);
        digester.addFactoryCreate(PathElement.getPattern(), (ObjectCreationFactory)new AttributeFactory("type"));
        digester.addFactoryCreate(PathElement.getPattern(), (ObjectCreationFactory)new AttributeFactory("datastage"));
        digester.addFactoryCreate(PathElement.getPattern() + "/browser", (ObjectCreationFactory)new FileBrowserFactory());
        digester.addSetRoot(PathElement.getPattern() + "/browser", "addFileBrowser");
        digester.parse(xmlFile);
        return fileBrowserTable;
    }

    public static class AttributeFactory
    implements ObjectCreationFactory {
        private String attributeName = null;

        public AttributeFactory(String attributeName) {
            this.attributeName = attributeName;
        }

        public Object createObject(Attributes attributes) {
            String attr = attributes.getValue(this.attributeName);
            if (attr != null) {
                return attr;
            }
            return "";
        }

        public Digester getDigester() {
            return null;
        }

        public void setDigester(Digester digester) {
        }
    }

    public static class FileBrowserFactory
    implements ObjectCreationFactory {
        Digester digester = null;

        public Object createObject(Attributes attributes) {
            String type = (String)this.digester.peek(1);
            String dataStage = (String)this.digester.peek(0);
            FileBrowserImpl browser = new FileBrowserImpl();
            browser.setDataStageName(dataStage);
            browser.setDataStageType(type);
            return browser;
        }

        public Digester getDigester() {
            return this.digester;
        }

        public void setDigester(Digester digester) {
            this.digester = digester;
        }
    }
}

