/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jsp;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.nesc.rapid.data.job.StageType;
import uk.ac.nesc.rapid.jsp.JSPOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
extends DefaultHandler {
    private SAXParser parser = null;
    private List<String> pageList = null;
    private int rapidelementcounter = 0;
    private String page = null;
    private String pageName = null;
    private String symbol = null;
    private String dataStage = null;
    private StageType stageType = null;
    private boolean isRadio = false;
    private boolean refresh = false;

    public Generator() throws ParserConfigurationException {
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        factory.setNamespaceAware(true);
        this.parser = factory.newSAXParser();
        this.pageList = new Vector<String>();
    }

    public List<String> getPageList() {
        return this.pageList;
    }

    public void generate(URL url) throws SAXException, IOException {
        this.parser.parse(url.getPath(), (DefaultHandler)this);
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (uri.equals("http://www.nesc.ac.uk/rapid")) {
            String display;
            String nextPage;
            ++this.rapidelementcounter;
            if (localName.equals("page")) {
                String name;
                this.pageName = name = attributes.getValue("name");
                this.page = "";
                this.page = this.page + JSPOutput.startPage(name);
            }
            if (localName.equals("includehtml")) {
                String filename = attributes.getValue("filename");
                this.page = this.page + JSPOutput.startInclude(filename);
            }
            if (localName.equals("navigate")) {
                nextPage = attributes.getValue("nextpage");
                display = attributes.getValue("display");
                this.page = this.page + JSPOutput.startNavigate(display, nextPage, this.pageName);
            }
            if (localName.equals("submit")) {
                nextPage = attributes.getValue("nextpage");
                display = attributes.getValue("display");
                this.page = this.page + JSPOutput.startSubmit(display, nextPage, this.pageName);
            }
            if (localName.equals("monitor")) {
                this.page = this.page + JSPOutput.startMonitor();
            }
            if (localName.equals("executable") || localName.equals("stdin") || localName.equals("stdout") || localName.equals("stderr") || localName.equals("workingdir") || localName.equals("parameter") || localName.equals("environmentname") || localName.equals("environmentvalue") || localName.equals("filesystem") || localName.equals("deleteontermination") || localName.equals("path") || localName.equals("filename") || localName.equals("creationflag") || localName.equals("submitto")) {
                this.symbol = attributes.getValue("symbol");
                this.refresh = localName.equals("filesystem");
            }
            if (localName.equals("path")) {
                this.dataStage = attributes.getValue("datastage");
                String type = attributes.getValue("type");
                StageType stageType = this.stageType = type == null ? StageType.SOURCE : StageType.parseString(type);
            }
            if (localName.equals("newfile")) {
                String display2 = attributes.getValue("display");
                this.page = this.page + JSPOutput.startNewFile(this.pageName, this.symbol, display2 == null ? "New File" : display2);
            }
            if (localName.equals("text") && this.symbol != null) {
                this.page = this.page + JSPOutput.startText(this.symbol);
            }
            if (localName.equals("list") && this.symbol != null) {
                String size = attributes.getValue("size");
                if (size == null) {
                    size = "10";
                }
                this.page = this.page + JSPOutput.startList(this.symbol, size);
                this.isRadio = false;
            }
            if (localName.equals("radio") && this.symbol != null) {
                this.isRadio = true;
            }
            if (localName.equals("item") && this.symbol != null) {
                String value = attributes.getValue("value");
                this.page = this.page + JSPOutput.startItem(this.symbol, this.pageName, value, this.isRadio, this.refresh);
            }
            if (localName.equals("output") && this.symbol != null) {
                this.page = this.page + JSPOutput.startOutput(this.symbol);
            }
            if (localName.equals("browser") && this.symbol != null) {
                this.page = this.page + JSPOutput.startBrowser(this.pageName, this.symbol, this.dataStage, this.stageType);
            }
        }
        if (uri.equals("http://www.w3.org/2002/06/xhtml2")) {
            this.page = this.page + "<" + localName;
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.page = this.page + " " + attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"";
            }
            this.page = this.page + ">";
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.rapidelementcounter == 2) {
            this.page = this.page + new String(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qname) {
        if (uri.equals("http://www.nesc.ac.uk/rapid")) {
            --this.rapidelementcounter;
            if (localName.equals("page")) {
                this.page = this.page + JSPOutput.endPage();
                this.pageList.add(this.page);
            }
            if (localName.equals("list")) {
                this.page = this.page + JSPOutput.endList();
            }
        }
        if (uri.equals("http://www.w3.org/2002/06/xhtml2")) {
            this.page = this.page + "</" + localName + ">\n";
        }
    }
}

