/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.element.impl;

import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.job.DataStage;
import uk.ac.nesc.rapid.data.job.DataStageURL;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.data.job.StageType;
import uk.ac.nesc.rapid.element.Element;

public class FileSystemElement
extends Element {
    private String dataStageName = null;
    private StageType stageType = StageType.SOURCE;

    public String get(Job job) throws RapidException {
        DataStage dataStage;
        DataStage dataStage2 = dataStage = job == null ? null : job.getDataStage(this.getDataStageName());
        if (dataStage == null) {
            throw new RapidException("No such datastage name '" + this.getDataStageName() + "'");
        }
        DataStageURL dataStageURL = dataStage.getURL(this.stageType);
        if (dataStageURL == null) {
            throw new RapidException("No datastage URL at datastage '" + this.getDataStageName() + "'" + " type '" + this.getStageType().toString() + "'");
        }
        return dataStageURL.getFileSystem();
    }

    public void put(Job job, String value) throws RapidException {
        if (this.isReadOnly() || value.equals("")) {
            return;
        }
        DataStage dataStage = job.getDataStage(this.getDataStageName());
        if (dataStage == null) {
            throw new RapidException("No such datastage name '" + this.getDataStageName() + "'");
        }
        dataStage.getURL(this.stageType).setFileSystem(value);
    }

    public String getDataStageName() {
        return this.dataStageName;
    }

    public void setDataStageName(String dataStageName) {
        this.dataStageName = dataStageName;
    }

    public StageType getStageType() {
        return this.stageType;
    }

    public void setStageType(StageType stageType) {
        this.stageType = stageType;
    }

    public void setStageType(String stageType) {
        this.stageType = StageType.parseString(stageType);
    }

    public static String getPattern() {
        return "*/datastage/filesystem";
    }

    public String toString() {
        String result = "";
        result = result + "FileSystem\n";
        result = result + super.toString();
        result = result + " DataStage: " + this.getDataStageName() + "\n";
        result = result + " Type: " + (Object)((Object)this.stageType) + "\n";
        return result;
    }
}

