/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.element.impl;

import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.job.EnvironmentVariable;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.element.Element;

public class EnvironmentNameElement
extends Element {
    private int index;

    public EnvironmentNameElement() throws RapidException {
        this.setIndex(0);
    }

    public String get(Job job) throws RapidException {
        EnvironmentVariable env = job.getEnvironmentVariable(this.index);
        if (env == null) {
            throw new RapidException("No Environment variable at index " + this.index);
        }
        return job.getEnvironmentVariable(this.getIndex()).getName();
    }

    public void put(Job job, String value) throws RapidException {
        if (this.isReadOnly()) {
            return;
        }
        EnvironmentVariable env = job.getEnvironmentVariable(this.index);
        if (env == null) {
            throw new RapidException("No Environment variable at index " + this.index);
        }
        env.setName(value);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setIndex(String index) {
        try {
            this.index = Integer.parseInt(index);
        }
        catch (NumberFormatException ex) {
            this.index = 0;
        }
    }

    public static String getPattern() {
        return "*/posix/environmentname";
    }

    public String toString() {
        String result = "";
        result = result + "Environment Name\n";
        result = result + super.toString();
        result = result + " Index: " + this.getIndex() + "\n";
        return result;
    }
}

