/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.filesystem;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs.provider.http.HttpFileProvider;
import org.apache.commons.vfs.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs.provider.sftp.SftpFileProvider;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.vfs.gsiftp.GSIFTPFileProvider;

public class FileSystemConnector {
    private DefaultFileSystemManager fsManager = new DefaultFileSystemManager();
    private static FileSystemConnector singleton = null;

    private FileSystemConnector() throws FileSystemException {
        this.fsManager.addProvider("ftp", (FileProvider)new FtpFileProvider());
        this.fsManager.addProvider("sftp", (FileProvider)new SftpFileProvider());
        this.fsManager.addProvider("http", (FileProvider)new HttpFileProvider());
        this.fsManager.addProvider("gsiftp", (FileProvider)new GSIFTPFileProvider());
        this.fsManager.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
        this.fsManager.init();
    }

    public static FileSystemConnector getInstance() throws FileSystemException {
        if (singleton == null) {
            singleton = new FileSystemConnector();
        }
        return singleton;
    }

    public FileObject connect(AbstractFileSystem fileSystem) throws FileSystemException, MyProxyException {
        FileSystemOptions options = new FileSystemOptions();
        fileSystem.addVFSOptions(options);
        return this.fsManager.resolveFile(fileSystem.getURL(), options);
    }
}

