/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data;

import java.io.IOException;
import java.net.URL;
import org.xml.sax.SAXException;
import uk.ac.nesc.rapid.data.RapidConfiguration;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.browser.FileBrowserTable;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.data.job.JobTable;
import uk.ac.nesc.rapid.data.job.impl.JobTableImpl;
import uk.ac.nesc.rapid.element.ElementTable;
import uk.ac.nesc.rapid.jobsubmission.SubmissionServerTable;
import uk.ac.nesc.rapid.xml.ElementTableReader;
import uk.ac.nesc.rapid.xml.FileBrowserReader;
import uk.ac.nesc.rapid.xml.FileSystemReader;
import uk.ac.nesc.rapid.xml.JobReader;
import uk.ac.nesc.rapid.xml.RapidConfigurationReader;
import uk.ac.nesc.rapid.xml.RapidXML;
import uk.ac.nesc.rapid.xml.SubmissionReader;

public class RapidData {
    private ElementTable elementTable = null;
    private JobTable jobTable = null;
    private SubmissionServerTable submissionServerTable = null;
    private FileBrowserTable fileBrowserTable = null;
    private FileSystemTable fileSystemTable = null;
    private RapidConfiguration rapidConfiguration = null;

    public RapidData(URL xmlFile) throws IOException, SAXException, RapidException {
        this.elementTable = ElementTableReader.read(xmlFile);
        this.jobTable = new JobTableImpl();
        URL url = RapidXML.getXMLSymbolFile();
        Job newJob = JobReader.read(url);
        this.jobTable.addJob(newJob);
        this.submissionServerTable = SubmissionReader.read(xmlFile);
        this.fileBrowserTable = FileBrowserReader.read(xmlFile);
        this.fileSystemTable = FileSystemReader.read(xmlFile);
        this.rapidConfiguration = RapidConfigurationReader.read(xmlFile);
    }

    public ElementTable getElementTable() {
        return this.elementTable;
    }

    public JobTable getJobTable() {
        return this.jobTable;
    }

    public SubmissionServerTable getSubmissionServerTable() {
        return this.submissionServerTable;
    }

    public FileBrowserTable getFileBrowserTable() {
        return this.fileBrowserTable;
    }

    public FileSystemTable getFileSystemTable() {
        return this.fileSystemTable;
    }

    public RapidConfiguration getRapidConfiguration() {
        return this.rapidConfiguration;
    }
}

