/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.vfs.sftp;

import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.Serializable;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import uk.ac.nesc.rapid.vfs.sftp.SftpFileSystem;

public class SftpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final SftpFileSystemConfigBuilder builder = new SftpFileSystemConfigBuilder();
    private static final String USER_DIR_IS_ROOT = SftpFileSystemConfigBuilder.class.getName() + ".USER_DIR_IS_ROOT";
    private static final String TIMEOUT = SftpFileSystemConfigBuilder.class.getName() + ".TIMEOUT";
    public static final ProxyType PROXY_HTTP = new ProxyType("http");
    public static final ProxyType PROXY_SOCKS5 = new ProxyType("socks");

    public static SftpFileSystemConfigBuilder getInstance() {
        return builder;
    }

    private SftpFileSystemConfigBuilder() {
    }

    public void setUserInfo(FileSystemOptions opts, UserInfo info) {
        this.setParam(opts, UserInfo.class.getName(), info);
    }

    public UserInfo getUserInfo(FileSystemOptions opts) {
        return (UserInfo)this.getParam(opts, UserInfo.class.getName());
    }

    public void setKnownHosts(FileSystemOptions opts, File sshdir) throws FileSystemException {
        this.setParam(opts, "knownHosts", sshdir);
    }

    public File getKnownHosts(FileSystemOptions opts) {
        return (File)this.getParam(opts, "knownHosts");
    }

    public void setIdentities(FileSystemOptions opts, File[] identities) throws FileSystemException {
        this.setParam(opts, "identities", identities);
    }

    public void setCompression(FileSystemOptions opts, String compression) throws FileSystemException {
        this.setParam(opts, "compression", compression);
    }

    public String getCompression(FileSystemOptions opts) {
        return (String)this.getParam(opts, "compression");
    }

    public File[] getIdentities(FileSystemOptions opts) {
        return (File[])this.getParam(opts, "identities");
    }

    public void setStrictHostKeyChecking(FileSystemOptions opts, String hostKeyChecking) throws FileSystemException {
        if (hostKeyChecking == null || !hostKeyChecking.equals("ask") && !hostKeyChecking.equals("no") && !hostKeyChecking.equals("yes")) {
            throw new FileSystemException("vfs.provider.sftp/StrictHostKeyChecking-arg.error", (Object)hostKeyChecking);
        }
        this.setParam(opts, "StrictHostKeyChecking", hostKeyChecking);
    }

    public String getStrictHostKeyChecking(FileSystemOptions opts) {
        return (String)this.getParam(opts, "StrictHostKeyChecking");
    }

    public void setUserDirIsRoot(FileSystemOptions opts, boolean userDirIsRoot) {
        this.setParam(opts, USER_DIR_IS_ROOT, userDirIsRoot ? Boolean.TRUE : Boolean.FALSE);
    }

    public Boolean getUserDirIsRoot(FileSystemOptions opts) {
        return (Boolean)this.getParam(opts, USER_DIR_IS_ROOT);
    }

    public void setTimeout(FileSystemOptions opts, Integer timeout) {
        this.setParam(opts, TIMEOUT, timeout);
    }

    public Integer getTimeout(FileSystemOptions opts) {
        return (Integer)this.getParam(opts, TIMEOUT);
    }

    protected Class getConfigClass() {
        return SftpFileSystem.class;
    }

    public void setProxyHost(FileSystemOptions opts, String proxyHost) {
        this.setParam(opts, "proxyHost", proxyHost);
    }

    public void setProxyPort(FileSystemOptions opts, int proxyPort) {
        this.setParam(opts, "proxyPort", new Integer(proxyPort));
    }

    public String getProxyHost(FileSystemOptions opts) {
        return (String)this.getParam(opts, "proxyHost");
    }

    public int getProxyPort(FileSystemOptions opts) {
        if (!this.hasParam(opts, "proxyPort")) {
            return 0;
        }
        return ((Number)this.getParam(opts, "proxyPort")).intValue();
    }

    public void setProxyType(FileSystemOptions opts, ProxyType proxyType) {
        this.setParam(opts, "proxyType", proxyType);
    }

    public ProxyType getProxyType(FileSystemOptions opts) {
        return (ProxyType)this.getParam(opts, "proxyType");
    }

    public void setHomeDir(FileSystemOptions opts, String homeDir) {
        this.setParam(opts, "sftp:homeDir", homeDir);
    }

    public String getHomeDir(FileSystemOptions opts) {
        return (String)this.getParam(opts, "sftp:homeDir");
    }

    public static class ProxyType
    implements Serializable,
    Comparable {
        private final String proxyType;

        private ProxyType(String proxyType) {
            this.proxyType = proxyType;
        }

        public int compareTo(Object o) {
            return this.proxyType.compareTo(((ProxyType)o).proxyType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProxyType proxyType1 = (ProxyType)o;
            return !(this.proxyType != null ? !this.proxyType.equals(proxyType1.proxyType) : proxyType1.proxyType != null);
        }
    }
}

