/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.vfs.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;
import uk.ac.nesc.rapid.vfs.sftp.SftpClientFactory;
import uk.ac.nesc.rapid.vfs.sftp.SftpFileObject;
import uk.ac.nesc.rapid.vfs.sftp.SftpFileProvider;
import uk.ac.nesc.rapid.vfs.sftp.SftpFileSystemConfigBuilder;

public class SftpFileSystem
extends AbstractFileSystem
implements FileSystem {
    private Session session;
    private ChannelSftp idleChannel;

    protected SftpFileSystem(GenericFileName rootName, Session session, FileSystemOptions fileSystemOptions) {
        super((FileName)rootName, null, fileSystemOptions);
        this.session = session;
    }

    protected void doCloseCommunicationLink() {
        if (this.idleChannel != null) {
            this.idleChannel.disconnect();
            this.idleChannel = null;
        }
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    protected ChannelSftp getChannel() throws IOException {
        block11: {
            Session session;
            if (this.session != null && this.session.isConnected()) break block11;
            this.doCloseCommunicationLink();
            UserAuthenticationData authData = null;
            try {
                GenericFileName rootName = (GenericFileName)this.getRootName();
                authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)this.getFileSystemOptions(), (UserAuthenticationData.Type[])SftpFileProvider.AUTHENTICATOR_TYPES);
                session = SftpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.USERNAME, (char[])UserAuthenticatorUtils.toChar((String)rootName.getUserName())), UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.PASSWORD, (char[])UserAuthenticatorUtils.toChar((String)rootName.getPassword())), this.getFileSystemOptions());
            }
            catch (Exception e) {
                try {
                    throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)this.getRootName(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    UserAuthenticatorUtils.cleanup(authData);
                    throw throwable;
                }
            }
            UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
            this.session = session;
        }
        try {
            ChannelSftp channel;
            if (this.idleChannel != null) {
                channel = this.idleChannel;
                this.idleChannel = null;
            } else {
                channel = (ChannelSftp)this.session.openChannel("sftp");
                channel.connect();
                Boolean userDirIsRoot = SftpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(this.getFileSystemOptions());
                String workingDirectory = this.getRootName().getPath();
                if (!(workingDirectory == null || userDirIsRoot != null && userDirIsRoot.booleanValue())) {
                    try {
                        channel.cd(workingDirectory);
                    }
                    catch (SftpException e) {
                        throw new FileSystemException("vfs.provider.sftp/change-work-directory.error", (Object)workingDirectory);
                    }
                }
            }
            return channel;
        }
        catch (JSchException e) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)this.getRootName(), (Throwable)e);
        }
    }

    protected void putChannel(ChannelSftp channel) {
        if (this.idleChannel == null) {
            if (channel.isConnected() && !channel.isClosed()) {
                this.idleChannel = channel;
            }
        } else {
            channel.disconnect();
        }
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(SftpFileProvider.capabilities);
    }

    protected FileObject createFile(FileName name) throws FileSystemException {
        return new SftpFileObject(name, this);
    }

    public double getLastModTimeAccuracy() {
        return 1000.0;
    }
}

