/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.vfs.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;
import uk.ac.nesc.rapid.vfs.sftp.SftpClientFactory;
import uk.ac.nesc.rapid.vfs.sftp.SftpFileNameParser;
import uk.ac.nesc.rapid.vfs.sftp.SftpFileSystem;
import uk.ac.nesc.rapid.vfs.sftp.SftpFileSystemConfigBuilder;

public class SftpFileProvider
extends AbstractOriginatingFileProvider {
    protected static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.GET_LAST_MODIFIED, Capability.SET_LAST_MODIFIED_FILE, Capability.RANDOM_ACCESS_READ));
    public static final String ATTR_USER_INFO = "UI";
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};

    public SftpFileProvider() {
        this.setFileNameParser((FileNameParser)SftpFileNameParser.getInstance());
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        Session session;
        GenericFileName rootName = (GenericFileName)name;
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)fileSystemOptions, (UserAuthenticationData.Type[])AUTHENTICATOR_TYPES);
            session = SftpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.USERNAME, (char[])UserAuthenticatorUtils.toChar((String)rootName.getUserName())), UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.PASSWORD, (char[])UserAuthenticatorUtils.toChar((String)rootName.getPassword())), fileSystemOptions);
            ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
            channel.connect();
            String homeDirectory = channel.pwd();
            SftpFileSystemConfigBuilder.getInstance().setHomeDir(fileSystemOptions, homeDirectory);
            this.setFileNameParser((FileNameParser)SftpFileNameParser.getInstance());
            channel.disconnect();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)name, (Throwable)e);
        }
        finally {
            UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        }
        return new SftpFileSystem(rootName, session, fileSystemOptions);
    }

    public void init() throws FileSystemException {
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return SftpFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }

    public FileName parseUri(FileName base, String uri) throws FileSystemException {
        if (this.getFileNameParser() != null) {
            return this.getFileNameParser().parseUri(this.getContext(), base, uri);
        }
        throw new FileSystemException("vfs.provider/filename-parser-missing.error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName name;
        FileSystem fs;
        FileName rootName = SftpFileNameParser.getInstance().getRootName(uri);
        SftpFileProvider sftpFileProvider = this;
        synchronized (sftpFileProvider) {
            fs = this.findFileSystem((Comparable)rootName, fileSystemOptions);
            String workingDirectory = null;
            if (fs == null) {
                fs = this.doCreateFileSystem(rootName, fileSystemOptions);
                this.addFileSystem((Comparable)rootName, fs);
                if (!Boolean.TRUE.equals(SftpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(fileSystemOptions))) {
                    workingDirectory = SftpFileSystemConfigBuilder.getInstance().getHomeDir(fileSystemOptions);
                }
            }
            name = SftpFileNameParser.getInstance().parseUri(null, workingDirectory, null, uri);
        }
        return fs.resolveFile(name);
    }
}

