/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.vfs.ftp;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.commons.vfs.provider.GenericFileName;
import uk.ac.nesc.rapid.vfs.ftp.FTPClientWrapper;
import uk.ac.nesc.rapid.vfs.ftp.FtpFileNameParser;
import uk.ac.nesc.rapid.vfs.ftp.FtpFileSystem;
import uk.ac.nesc.rapid.vfs.ftp.FtpFileSystemConfigBuilder;

public class FtpFileProvider
extends AbstractOriginatingFileProvider {
    public static final String ATTR_FILE_ENTRY_PARSER = "FEP";
    static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.GET_LAST_MODIFIED, Capability.URI, Capability.WRITE_CONTENT, Capability.APPEND_CONTENT, Capability.RANDOM_ACCESS_READ));
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};

    public FtpFileProvider() {
        this.setFileNameParser((FileNameParser)FtpFileNameParser.getInstance());
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName rootName = (GenericFileName)name;
        FTPClientWrapper ftpClient = new FTPClientWrapper(rootName, fileSystemOptions);
        return new FtpFileSystem(rootName, ftpClient, fileSystemOptions);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return FtpFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName name;
        FileSystem fs;
        FileName rootName = FtpFileNameParser.getInstance().getRootName(uri);
        FtpFileProvider ftpFileProvider = this;
        synchronized (ftpFileProvider) {
            fs = this.findFileSystem((Comparable)rootName, fileSystemOptions);
            String workingDirectory = null;
            if (fs == null) {
                fs = this.doCreateFileSystem(rootName, fileSystemOptions);
                this.addFileSystem((Comparable)rootName, fs);
                if (!Boolean.TRUE.equals(FtpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(fileSystemOptions))) {
                    workingDirectory = FtpFileSystemConfigBuilder.getInstance().getHomeDir(fileSystemOptions);
                }
            }
            name = FtpFileNameParser.getInstance().parseUri(null, workingDirectory, null, uri);
        }
        return fs.resolveFile(name);
    }
}

