/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.vfs.ftp;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;
import uk.ac.nesc.rapid.vfs.ftp.FtpFileSystemConfigBuilder;

public class FtpClientFactory {
    private FtpClientFactory() {
    }

    public static FTPClient createConnection(String hostname, int port, char[] username, char[] password, String workingDirectory, FileSystemOptions fileSystemOptions) throws FileSystemException {
        if (username == null) {
            username = "anonymous".toCharArray();
        }
        if (password == null) {
            password = "anonymous".toCharArray();
        }
        try {
            FTPFileEntryParserFactory myFactory;
            FTPClient client = new FTPClient();
            String key = FtpFileSystemConfigBuilder.getInstance().getEntryParser(fileSystemOptions);
            if (key != null) {
                String[] shortMonthNames;
                String serverTimeZoneId;
                String recentDateFormat;
                String defaultDateFormat;
                FTPClientConfig config = new FTPClientConfig(key);
                String serverLanguageCode = FtpFileSystemConfigBuilder.getInstance().getServerLanguageCode(fileSystemOptions);
                if (serverLanguageCode != null) {
                    config.setServerLanguageCode(serverLanguageCode);
                }
                if ((defaultDateFormat = FtpFileSystemConfigBuilder.getInstance().getDefaultDateFormat(fileSystemOptions)) != null) {
                    config.setDefaultDateFormatStr(defaultDateFormat);
                }
                if ((recentDateFormat = FtpFileSystemConfigBuilder.getInstance().getRecentDateFormat(fileSystemOptions)) != null) {
                    config.setRecentDateFormatStr(recentDateFormat);
                }
                if ((serverTimeZoneId = FtpFileSystemConfigBuilder.getInstance().getServerTimeZoneId(fileSystemOptions)) != null) {
                    config.setServerTimeZoneId(serverTimeZoneId);
                }
                if ((shortMonthNames = FtpFileSystemConfigBuilder.getInstance().getShortMonthNames(fileSystemOptions)) != null) {
                    StringBuffer shortMonthNamesStr = new StringBuffer(40);
                    for (int i = 0; i < shortMonthNames.length; ++i) {
                        if (shortMonthNamesStr.length() > 0) {
                            shortMonthNamesStr.append("|");
                        }
                        shortMonthNamesStr.append(shortMonthNames[i]);
                    }
                    config.setShortMonthNames(shortMonthNamesStr.toString());
                }
                client.configure(config);
            }
            if ((myFactory = FtpFileSystemConfigBuilder.getInstance().getEntryParserFactory(fileSystemOptions)) != null) {
                client.setParserFactory(myFactory);
            }
            try {
                client.connect(hostname, port);
                int reply = client.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)reply)) {
                    throw new FileSystemException("vfs.provider.ftp/connect-rejected.error", (Object)hostname);
                }
                if (!client.login(UserAuthenticatorUtils.toString((char[])username), UserAuthenticatorUtils.toString((char[])password))) {
                    throw new FileSystemException("vfs.provider.ftp/login.error", new Object[]{hostname, UserAuthenticatorUtils.toString((char[])username)}, null);
                }
                if (!client.setFileType(2)) {
                    throw new FileSystemException("vfs.provider.ftp/set-binary.error", (Object)hostname);
                }
                Integer dataTimeout = FtpFileSystemConfigBuilder.getInstance().getDataTimeout(fileSystemOptions);
                if (dataTimeout != null) {
                    client.setDataTimeout(dataTimeout.intValue());
                }
                try {
                    FtpFileSystemConfigBuilder.getInstance().setHomeDir(fileSystemOptions, client.printWorkingDirectory());
                }
                catch (IOException ex) {
                    throw new FileSystemException("Error obtaining working directory!");
                }
                Boolean userDirIsRoot = FtpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(fileSystemOptions);
                if (!(workingDirectory == null || userDirIsRoot != null && userDirIsRoot.booleanValue() || client.changeWorkingDirectory(workingDirectory))) {
                    throw new FileSystemException("vfs.provider.ftp/change-work-directory.error", (Object)workingDirectory);
                }
                Boolean passiveMode = FtpFileSystemConfigBuilder.getInstance().getPassiveMode(fileSystemOptions);
                if (passiveMode != null && passiveMode.booleanValue()) {
                    client.enterLocalPassiveMode();
                }
            }
            catch (IOException e) {
                if (client.isConnected()) {
                    client.disconnect();
                }
                throw e;
            }
            return client;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.ftp/connect.error", new Object[]{hostname}, (Throwable)exc);
        }
    }
}

