/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.vfs.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;
import uk.ac.nesc.rapid.vfs.ftp.FtpClient;
import uk.ac.nesc.rapid.vfs.ftp.FtpClientFactory;
import uk.ac.nesc.rapid.vfs.ftp.FtpFileProvider;

class FTPClientWrapper
implements FtpClient {
    private final GenericFileName root;
    private final FileSystemOptions fileSystemOptions;
    private FTPClient ftpClient = null;

    FTPClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = fileSystemOptions;
        this.getFtpClient();
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPClient createClient() throws FileSystemException {
        FTPClient fTPClient;
        GenericFileName rootName = this.getRoot();
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)this.fileSystemOptions, (UserAuthenticationData.Type[])FtpFileProvider.AUTHENTICATOR_TYPES);
            fTPClient = FtpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.USERNAME, (char[])UserAuthenticatorUtils.toChar((String)rootName.getUserName())), UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.PASSWORD, (char[])UserAuthenticatorUtils.toChar((String)rootName.getPassword())), rootName.getPath(), this.getFileSystemOptions());
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        return fTPClient;
    }

    private FTPClient getFtpClient() throws FileSystemException {
        if (this.ftpClient == null) {
            this.ftpClient = this.createClient();
        }
        return this.ftpClient;
    }

    public boolean isConnected() throws FileSystemException {
        return this.ftpClient != null && this.ftpClient.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        try {
            this.getFtpClient().disconnect();
        }
        finally {
            this.ftpClient = null;
        }
    }

    public FTPFile[] listFiles(String relPath) throws IOException {
        try {
            return this.getFtpClient().listFiles(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().listFiles(relPath);
        }
    }

    public boolean removeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().removeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().removeDirectory(relPath);
        }
    }

    public boolean deleteFile(String relPath) throws IOException {
        try {
            return this.getFtpClient().deleteFile(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().deleteFile(relPath);
        }
    }

    public boolean rename(String oldName, String newName) throws IOException {
        try {
            return this.getFtpClient().rename(oldName, newName);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().rename(oldName, newName);
        }
    }

    public boolean makeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().makeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().makeDirectory(relPath);
        }
    }

    public boolean completePendingCommand() throws IOException {
        if (this.ftpClient != null) {
            return this.getFtpClient().completePendingCommand();
        }
        return true;
    }

    public InputStream retrieveFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().retrieveFileStream(relPath);
        }
    }

    public InputStream retrieveFileStream(String relPath, long restartOffset) throws IOException {
        try {
            FTPClient client = this.getFtpClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            FTPClient client = this.getFtpClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
    }

    public OutputStream appendFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().appendFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().appendFileStream(relPath);
        }
    }

    public OutputStream storeFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().storeFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().storeFileStream(relPath);
        }
    }

    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException e) {
            this.disconnect();
            return true;
        }
    }

    public String getReplyString() throws IOException {
        return this.getFtpClient().getReplyString();
    }

    public String getWorkingDirectory() throws IOException {
        return this.getFtpClient().printWorkingDirectory();
    }
}

