/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.vfs.common;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.URLFileNameParser;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponentContext;

public class FtpBaseFileNameParser
extends URLFileNameParser {
    public FtpBaseFileNameParser(int port) {
        super(port);
    }

    public FtpBaseFileNameParser() {
        super(22);
    }

    public FileName getRootName(String filename) throws FileSystemException {
        String[] split = filename.split("://");
        if (split.length != 2) {
            throw new FileSystemException("Filename does not adhere to 'scheme://path");
        }
        String scheme = UriParser.decode((String)split[0]);
        String rest = split[1];
        if ((split = rest.split("@")).length > 2) {
            throw new FileSystemException("Filename contains more than one '@' character");
        }
        if (split.length == 2) {
            rest = split[1];
        }
        split = rest.split("/", 2);
        split = split[0].split(":");
        String hostname = split[0];
        String port = null;
        if (split.length == 2) {
            port = split[1];
        }
        return new URLFileName(scheme, hostname, port == null ? -1 : Integer.parseInt(port), this.getDefaultPort(), null, null, "/", FileType.FOLDER, null);
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        return this.parseUri(context, null, base, filename);
    }

    public FileName parseUri(VfsComponentContext context, String homeDirectory, FileName base, String filename) throws FileSystemException {
        String[] split = filename.split("://");
        if (split.length != 2) {
            throw new FileSystemException("Filename does not adhere to 'scheme://path");
        }
        String scheme = UriParser.decode((String)split[0]);
        String rest = split[1];
        String username = null;
        String password = null;
        split = rest.split("@");
        if (split.length > 2) {
            throw new FileSystemException("Filename contains more than one '@' character");
        }
        if (split.length == 2) {
            rest = split[1];
            if ((split = split[0].split(":")).length > 2) {
                throw new FileSystemException("Filename contains more than one ':' character in user ID");
            }
            username = UriParser.decode((String)split[0]);
            if (split.length == 2) {
                password = UriParser.decode((String)split[1]);
            }
        }
        String path = (split = rest.split("/", 2)).length == 2 ? UriParser.decode((String)split[1]) : "";
        split = split[0].split(":");
        String hostname = split[0];
        String port = null;
        if (split.length == 2) {
            port = split[1];
        }
        path = homeDirectory == null || path.length() > 0 && path.startsWith("/") ? path : homeDirectory + "/" + path;
        StringBuffer pathBuffer = new StringBuffer(path);
        FileType fileType = UriParser.normalisePath((StringBuffer)pathBuffer);
        path = pathBuffer.toString();
        return new URLFileName(scheme, hostname, port == null ? -1 : Integer.parseInt(port), this.getDefaultPort(), username, password, path, fileType, null);
    }
}

