/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.vfs.gsiftp;

import java.util.Collection;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.globus.ftp.DataChannelAuthentication;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import uk.ac.nesc.rapid.vfs.gsiftp.ExtendedGridFTPClient;
import uk.ac.nesc.rapid.vfs.gsiftp.GSIFTPFileObject;
import uk.ac.nesc.rapid.vfs.gsiftp.GSIFTPFileProvider;
import uk.ac.nesc.rapid.vfs.gsiftp.GSIFTPFileSystemConfigBuilder;

public class GSIFTPFileSystem
extends AbstractFileSystem {
    private ExtendedGridFTPClient client = null;
    private String homeDirAttribute = "/";
    public static final String HOMEDIR = "GSIFTP_HOMEDIR";
    public static final String LIFETIME = "GSIFTP_LIFETIME";

    protected GSIFTPFileSystem(GenericFileName rootName, FileSystemOptions options) throws FileSystemException {
        super((FileName)rootName, null, options);
        try {
            this.client = GSIFTPFileSystem.createGridFTPClient((GenericFileName)this.getRootName(), this.getFileSystemOptions());
            this.setAttribute(HOMEDIR, this.client.getCurrentDir());
            Boolean userDirIsRoot = GSIFTPFileSystemConfigBuilder.getInstance().getUserDirIsRoot(this.getFileSystemOptions());
            this.client.setPassive();
            this.client.setLocalActive();
            this.client.setType(1);
            if (userDirIsRoot == null || !userDirIsRoot.booleanValue()) {
                this.client.changeDir("/");
            }
        }
        catch (Exception ex) {
            throw new FileSystemException("Error getting GridFTP client: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedGridFTPClient getClient() throws FileSystemException {
        GSIFTPFileSystem gSIFTPFileSystem = this;
        synchronized (gSIFTPFileSystem) {
            if (this.client == null) {
                try {
                    this.client = GSIFTPFileSystem.createGridFTPClient((GenericFileName)this.getRootName(), this.getFileSystemOptions());
                    Boolean userDirIsRoot = GSIFTPFileSystemConfigBuilder.getInstance().getUserDirIsRoot(this.getFileSystemOptions());
                    this.client.setPassive();
                    this.client.setLocalActive();
                    this.client.setType(1);
                    if (userDirIsRoot == null || !userDirIsRoot.booleanValue()) {
                        this.client.changeDir("/");
                    }
                }
                catch (Exception ex) {
                    throw new FileSystemException("Error getting GridFTP client: " + ex.getMessage());
                }
            }
            ExtendedGridFTPClient returnClient = this.client;
            this.client = null;
            return returnClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putClient(ExtendedGridFTPClient putClient) throws FileSystemException {
        GSIFTPFileSystem gSIFTPFileSystem = this;
        synchronized (gSIFTPFileSystem) {
            if (this.client == null) {
                this.client = putClient;
            } else {
                try {
                    putClient.close();
                }
                catch (Exception ex) {
                    throw new FileSystemException(ex.getMessage());
                }
            }
        }
    }

    private static ExtendedGridFTPClient createGridFTPClient(GenericFileName fileName, FileSystemOptions options) throws FileSystemException {
        try {
            ExtendedGridFTPClient newClient = new ExtendedGridFTPClient(fileName.getHostName(), fileName.getPort());
            GSSCredential credential = GSIFTPFileSystemConfigBuilder.getInstance().getGSSCredential(options);
            if (credential == null) {
                throw new FileSystemException("Could not obtain x509 proxy");
            }
            newClient.authenticate(credential);
            newClient.setDataChannelAuthentication(DataChannelAuthentication.NONE);
            return newClient;
        }
        catch (Exception ex) {
            throw new FileSystemException("GSIFTP Error ", (Object)("Filename: " + fileName + " : " + ex.getMessage()), (Throwable)ex);
        }
    }

    public Object getAttribute(String attrName) throws FileSystemException {
        if (HOMEDIR.equals(attrName)) {
            return this.homeDirAttribute;
        }
        if (LIFETIME.equals(attrName)) {
            try {
                GSSCredential credential = GSIFTPFileSystemConfigBuilder.getInstance().getGSSCredential(this.getFileSystemOptions());
                if (credential == null) {
                    throw new FileSystemException("Could not obtain x509 proxy");
                }
                return credential.getRemainingLifetime();
            }
            catch (GSSException ex) {
                throw new FileSystemException("Unable to determine lifetime of x509 proxy : " + ex.getMessage());
            }
        }
        return super.getAttribute(attrName);
    }

    public void setAttribute(String attrName, String value) throws FileSystemException {
        if (HOMEDIR.equals(attrName)) {
            this.homeDirAttribute = value;
        } else {
            super.setAttribute(attrName, (Object)value);
        }
    }

    protected FileObject createFile(FileName name) throws Exception {
        return new GSIFTPFileObject(name, this, this.getRootName());
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(GSIFTPFileProvider.CAPABILITIES);
    }

    protected synchronized void doCloseCommunicationLink() {
        super.doCloseCommunicationLink();
        try {
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

