/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml;

import java.security.cert.X509Certificate;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.w3c.dom.Element;

public class SAMLUtil {
    private static Log log = LogFactory.getLog((String)SAMLUtil.class.getName());

    public static X509Certificate[] getCertificatesFromSAML(Element elem) throws WSSecurityException {
        SAMLAssertion assertion;
        try {
            assertion = new SAMLAssertion(elem);
        }
        catch (SAMLException e) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (cannot parse)"});
        }
        SAMLSubjectStatement samlSubjS = null;
        Iterator it = assertion.getStatements();
        while (it.hasNext()) {
            SAMLObject so = (SAMLObject)it.next();
            if (!(so instanceof SAMLSubjectStatement)) continue;
            samlSubjS = (SAMLSubjectStatement)so;
            break;
        }
        SAMLSubject samlSubj = null;
        if (samlSubjS != null) {
            samlSubj = samlSubjS.getSubject();
        }
        if (samlSubj == null) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (no Subject)"});
        }
        Element e = samlSubj.getKeyInfo();
        X509Certificate[] certs = null;
        try {
            KeyInfo ki = new KeyInfo(e, null);
            if (ki.containsX509Data()) {
                X509Data data = ki.itemX509Data(0);
                XMLX509Certificate certElem = null;
                if (data != null && data.containsCertificate()) {
                    certElem = data.itemCertificate(0);
                }
                if (certElem != null) {
                    X509Certificate cert = certElem.getX509Certificate();
                    certs = new X509Certificate[]{cert};
                }
            }
        }
        catch (XMLSecurityException e3) {
            throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate (key holder)"});
        }
        return certs;
    }

    public static String getAssertionId(Element envelope, String elemName, String nmSpace) throws WSSecurityException {
        String id;
        Element assertionElement = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
        try {
            SAMLAssertion assertion = new SAMLAssertion(assertionElement);
            id = assertion.getId();
        }
        catch (Exception e1) {
            log.error((Object)e1);
            throw new WSSecurityException(9, "noXMLSig", null, e1);
        }
        return id;
    }
}

