/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.processor.Processor;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.w3c.dom.Element;

public class SAMLTokenProcessor
implements Processor {
    private static Log log = LogFactory.getLog((String)SAMLTokenProcessor.class.getName());

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found SAML Assertion element");
        }
        SAMLAssertion assertion = this.handleSAMLToken(elem);
        wsDocInfo.setAssertion(elem);
        returnResults.add(0, new WSSecurityEngineResult(8, assertion));
    }

    public SAMLAssertion handleSAMLToken(Element token) throws WSSecurityException {
        boolean result = false;
        SAMLAssertion assertion = null;
        try {
            assertion = new SAMLAssertion(token);
            result = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("SAML Assertion issuer " + assertion.getIssuer()));
            }
        }
        catch (SAMLException e) {
            throw new WSSecurityException(0, "invalidSAMLsecurity", null, e);
        }
        if (!result) {
            throw new WSSecurityException(5);
        }
        return assertion;
    }

    public String getId() {
        return null;
    }
}

