/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.model;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.AlgorithmSuite;
import org.apache.ws.security.policy.model.AsymmetricBinding;
import org.apache.ws.security.policy.model.EncryptionToken;
import org.apache.ws.security.policy.model.Header;
import org.apache.ws.security.policy.model.InitiatorToken;
import org.apache.ws.security.policy.model.Layout;
import org.apache.ws.security.policy.model.ProtectionToken;
import org.apache.ws.security.policy.model.RecipientToken;
import org.apache.ws.security.policy.model.SignatureToken;
import org.apache.ws.security.policy.model.SignedEncryptedElements;
import org.apache.ws.security.policy.model.SignedEncryptedParts;
import org.apache.ws.security.policy.model.SupportingToken;
import org.apache.ws.security.policy.model.SymmetricBinding;
import org.apache.ws.security.policy.model.TransportBinding;
import org.apache.ws.security.policy.model.UsernameToken;
import org.apache.ws.security.policy.model.Wss10;
import org.apache.ws.security.policy.model.Wss11;
import org.apache.ws.security.policy.model.X509Token;
import org.apache.ws.security.policy.parser.SecurityPolicy;

public class PolicyEngineData {
    private static Log log = LogFactory.getLog(PolicyEngineData.class);

    public void initializeWithDefaults() {
    }

    public static PolicyEngineData copy(QName name) throws WSSPolicyException {
        if (name.getLocalPart().equals(SecurityPolicy.symmetricBinding.getTokenName())) {
            return new SymmetricBinding();
        }
        if (name.getLocalPart().equals(SecurityPolicy.asymmetricBinding.getTokenName())) {
            return new AsymmetricBinding();
        }
        if (name.getLocalPart().equals(SecurityPolicy.transportBinding.getTokenName())) {
            return new TransportBinding();
        }
        if (name.getLocalPart().equals(SecurityPolicy.algorithmSuite.getTokenName())) {
            return new AlgorithmSuite();
        }
        if (name.getLocalPart().equals(SecurityPolicy.signedElements.getTokenName())) {
            return new SignedEncryptedElements(true);
        }
        if (name.getLocalPart().equals(SecurityPolicy.encryptedElements.getTokenName())) {
            return new SignedEncryptedElements(false);
        }
        if (name.getLocalPart().equals(SecurityPolicy.signedParts.getTokenName())) {
            return new SignedEncryptedParts(true);
        }
        if (name.getLocalPart().equals(SecurityPolicy.encryptedParts.getTokenName())) {
            return new SignedEncryptedParts(false);
        }
        if (name.getLocalPart().equals(SecurityPolicy.header.getTokenName())) {
            return new Header();
        }
        if (name.getLocalPart().equals(SecurityPolicy.protectionToken.getTokenName())) {
            return new ProtectionToken();
        }
        if (name.getLocalPart().equals(SecurityPolicy.signatureToken.getTokenName())) {
            return new SignatureToken();
        }
        if (name.getLocalPart().equals(SecurityPolicy.encryptionToken.getTokenName())) {
            return new EncryptionToken();
        }
        if (name.getLocalPart().equals(SecurityPolicy.x509Token.getTokenName())) {
            return new X509Token();
        }
        if (name.getLocalPart().equals(SecurityPolicy.layout.getTokenName())) {
            return new Layout();
        }
        if (name.getLocalPart().equals(SecurityPolicy.signedSupportingTokens.getTokenName())) {
            return new SupportingToken(3);
        }
        if (name.getLocalPart().equals(SecurityPolicy.signedEndorsingSupportingTokens.getTokenName())) {
            return new SupportingToken(4);
        }
        if (name.getLocalPart().equals(SecurityPolicy.supportingTokens.getTokenName())) {
            return new SupportingToken(1);
        }
        if (name.getLocalPart().equals(SecurityPolicy.endorsingSupportingTokens.getTokenName())) {
            return new SupportingToken(2);
        }
        if (name.getLocalPart().equals(SecurityPolicy.usernameToken.getTokenName())) {
            return new UsernameToken();
        }
        if (name.getLocalPart().equals(SecurityPolicy.wss10.getTokenName())) {
            return new Wss10();
        }
        if (name.getLocalPart().equals(SecurityPolicy.wss11.getTokenName())) {
            return new Wss11();
        }
        if (name.getLocalPart().equals(SecurityPolicy.initiatorToken.getTokenName())) {
            return new InitiatorToken();
        }
        if (name.getLocalPart().equals(SecurityPolicy.recipientToken.getTokenName())) {
            return new RecipientToken();
        }
        log.error((Object)("Unsuppotred: " + name.getLocalPart()));
        throw new WSSPolicyException("Unsuppotred complex assertion :" + name.getLocalPart());
    }
}

