/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SecurityTokenReference {
    private static Log log = LogFactory.getLog((String)SecurityTokenReference.class.getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    public static final String SECURITY_TOKEN_REFERENCE = "SecurityTokenReference";
    public static final String KEY_NAME = "KeyName";
    public static final String SKI_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier";
    public static final String THUMB_URI = "http://docs.oasis-open.org/wss/2004/xx/oasis-2004xx-wss-soap-message-security-1.0#ThumbprintSHA1";
    public static final String SAML_ID_URI = "http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-saml-token-profile-1.0#SAMLAssertionID";
    protected Element element = null;
    private XMLX509IssuerSerial issuerSerial = null;
    private byte[] skiBytes = null;
    private static boolean doDebug = false;

    public SecurityTokenReference(Element elem) throws WSSecurityException {
        doDebug = log.isDebugEnabled();
        this.element = elem;
        boolean goodElement = false;
        if (SECURITY_TOKEN_REFERENCE.equals(this.element.getLocalName())) {
            goodElement = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(this.element.getNamespaceURI());
        }
        if (!goodElement) {
            throw new WSSecurityException(0, "badElement", null);
        }
    }

    public SecurityTokenReference(Document doc) {
        doDebug = log.isDebugEnabled();
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
    }

    public void setReference(Reference ref) {
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(ref.getElement(), elem);
        } else {
            this.element.appendChild(ref.getElement());
        }
    }

    public Reference getReference() throws WSSecurityException {
        Element elem = this.getFirstElement();
        return new Reference(elem);
    }

    public Element getTokenElement(Document doc, WSDocInfo docInfo) throws WSSecurityException {
        Reference ref = this.getReference();
        String uri = ref.getURI();
        if (doDebug) {
            log.debug((Object)("Token reference uri: " + uri));
        }
        if (uri == null) {
            throw new WSSecurityException(3, "badReferenceURI");
        }
        Element tokElement = null;
        String tmpS = "http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-saml-token-profile-1.0#SAMLAssertion-1.1";
        if (tmpS.equals(ref.getValueType())) {
            Element sa = docInfo.getAssertion();
            String saID = null;
            if (sa != null) {
                saID = sa.getAttribute("AssertionID");
            }
            if (doDebug) {
                log.debug((Object)("SAML token ID: " + saID));
            }
            String id = uri.substring(1);
            if (saID == null || !saID.equals(id)) {
                throw new WSSecurityException(3, "badReferenceURI", new Object[]{"uri:" + uri + ", saID: " + saID});
            }
            tokElement = sa;
        } else {
            tokElement = WSSecurityUtil.getElementByWsuId(doc, uri);
        }
        if (tokElement == null) {
            throw new WSSecurityException(7, "noToken", new Object[]{uri});
        }
        return tokElement;
    }

    public void setKeyIdentifier(X509Certificate cert) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        byte[] data = null;
        try {
            data = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError");
        }
        Text text = doc.createTextNode(Base64.encode(data));
        this.createKeyIdentifier(doc, X509Security.getType(), text);
    }

    public void setKeyIdentifierSKI(X509Certificate cert, Crypto crypto) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        byte[] data = crypto.getSKIBytesFromCert(cert);
        Text text = doc.createTextNode(Base64.encode(data));
        this.createKeyIdentifier(doc, SKI_URI, text);
    }

    public void setKeyIdentifierThumb(X509Certificate cert) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new WSSecurityException(0, "noSHA1availabe");
        }
        sha.reset();
        try {
            sha.update(cert.getEncoded());
        }
        catch (CertificateEncodingException e1) {
            throw new WSSecurityException(7, "encodeError");
        }
        byte[] data = sha.digest();
        Text text = doc.createTextNode(Base64.encode(data));
        this.createKeyIdentifier(doc, THUMB_URI, text);
    }

    public void setSAMLKeyIdentifier(String keyIdVal) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        this.createKeyIdentifier(doc, SAML_ID_URI, doc.createTextNode(keyIdVal));
    }

    private void createKeyIdentifier(Document doc, String uri, Node node) {
        Element keyId = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
        keyId.setAttributeNS(null, "ValueType", uri);
        keyId.setAttributeNS(null, "EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        keyId.appendChild(node);
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(keyId, elem);
        } else {
            this.element.appendChild(keyId);
        }
    }

    public X509Certificate[] getKeyIdentifier(Crypto crypto) throws WSSecurityException {
        X509Security token = null;
        Element elem = this.getFirstElement();
        String value = elem.getAttribute("ValueType");
        String alias = null;
        if (X509Security.getType().equals(value)) {
            token = new X509Security(elem);
            if (token != null) {
                X509Certificate cert = token.getX509Certificate(crypto);
                X509Certificate[] certs = new X509Certificate[]{cert};
                return certs;
            }
        } else if (SKI_URI.equals(value)) {
            alias = this.getX509SKIAlias(crypto);
        } else if (THUMB_URI.equals(value)) {
            Node node = this.getFirstElement().getFirstChild();
            if (node == null) {
                return null;
            }
            if (node.getNodeType() == 3) {
                byte[] thumb = Base64.decode(((Text)node).getData());
                alias = crypto.getAliasForX509CertThumb(thumb);
            }
        }
        if (alias != null) {
            return crypto.getCertificates(alias);
        }
        return null;
    }

    public String getX509SKIAlias(Crypto crypto) throws WSSecurityException {
        if (this.skiBytes == null) {
            this.skiBytes = this.getSKIBytes();
            if (this.skiBytes == null) {
                return null;
            }
        }
        String alias = crypto.getAliasForX509Cert(this.skiBytes);
        if (doDebug) {
            log.info((Object)("X509 SKI alias: " + alias));
        }
        return alias;
    }

    public byte[] getSKIBytes() {
        if (this.skiBytes != null) {
            return this.skiBytes;
        }
        Node node = this.getFirstElement().getFirstChild();
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 3) {
            try {
                this.skiBytes = Base64.decode(((Text)node).getData());
            }
            catch (WSSecurityException e) {
                return null;
            }
        }
        return this.skiBytes;
    }

    public void setX509IssuerSerial(X509Data ref) {
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(ref.getElement(), elem);
        } else {
            this.element.appendChild(ref.getElement());
        }
    }

    public X509Certificate[] getX509IssuerSerial(Crypto crypto) throws WSSecurityException {
        String alias = this.getX509IssuerSerialAlias(crypto);
        if (alias != null) {
            return crypto.getCertificates(alias);
        }
        return null;
    }

    public String getX509IssuerSerialAlias(Crypto crypto) throws WSSecurityException {
        if (this.issuerSerial == null) {
            this.issuerSerial = this.getIssuerSerial();
            if (this.issuerSerial == null) {
                return null;
            }
        }
        String alias = crypto.getAliasForX509Cert(this.issuerSerial.getIssuerName(), this.issuerSerial.getSerialNumber());
        if (doDebug) {
            log.info((Object)("X509IssuerSerial alias: " + alias));
        }
        return alias;
    }

    private XMLX509IssuerSerial getIssuerSerial() throws WSSecurityException {
        if (this.issuerSerial != null) {
            return this.issuerSerial;
        }
        Element elem = this.getFirstElement();
        if (elem == null) {
            return null;
        }
        try {
            if ("X509Data".equals(elem.getLocalName())) {
                elem = (Element)WSSecurityUtil.findElement(elem, "X509IssuerSerial", "http://www.w3.org/2000/09/xmldsig#");
            }
            this.issuerSerial = new XMLX509IssuerSerial(elem, "");
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(7, "noToken", new Object[]{"Issuer/Serial data element missing"});
        }
        return this.issuerSerial;
    }

    public Element getFirstElement() {
        for (Node currentChild = this.element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!(currentChild instanceof Element)) continue;
            return (Element)currentChild;
        }
        return null;
    }

    public boolean containsReference() {
        return this.lengthReference() > 0;
    }

    public int lengthReference() {
        return this.length("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference");
    }

    public boolean containsX509IssuerSerial() {
        return this.lengthX509IssuerSerial() > 0;
    }

    public boolean containsX509Data() {
        return this.lengthX509Data() > 0;
    }

    public int lengthX509IssuerSerial() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
    }

    public int lengthX509Data() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public boolean containsKeyIdentifier() {
        return this.lengthKeyIdentifier() > 0;
    }

    public int lengthKeyIdentifier() {
        return this.length("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier");
    }

    public int length(String namespace, String localname) {
        NodeList childNodes = this.element.getChildNodes();
        int maxLength = childNodes.getLength();
        int result = 0;
        for (int i = 0; i < maxLength; ++i) {
            Node n = childNodes.item(i);
            if (n.getNodeType() != 1) continue;
            String ns = n.getNamespaceURI();
            String name = n.getLocalName();
            if ((namespace == null || ns == null || !namespace.equals(ns)) && (namespace != null || ns != null) || !localname.equals(name)) continue;
            ++result;
        }
        return result;
    }

    public Element getElement() {
        return this.element;
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }
}

