/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;

public class WSSecUsernameToken
extends WSSecBase {
    private static Log log = LogFactory.getLog((String)WSSecUsernameToken.class.getName());
    private String passwordType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
    private UsernameToken ut = null;
    private String id = null;
    private boolean nonce = false;
    private boolean created = false;
    private Document document = null;

    public void setPasswordType(String pwType) {
        if (pwType == null) {
            this.passwordType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
        } else if (pwType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest") || pwType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText")) {
            this.passwordType = pwType;
        }
    }

    public void addNonce() {
        this.nonce = true;
    }

    public void addCreated() {
        this.created = true;
    }

    public byte[] getSecretKey() {
        if (this.ut == null) {
            return null;
        }
        return this.ut.getSecretKey();
    }

    public String getId() {
        if (this.ut == null) {
            return null;
        }
        return this.ut.getID();
    }

    public void prepare(Document doc) {
        this.document = doc;
        this.ut = new UsernameToken(this.wssConfig.isPrecisionInMilliSeconds(), doc, this.passwordType);
        this.ut.setName(this.user);
        this.ut.setPassword(this.password);
        String utId = "UsernameToken-" + this.ut.hashCode();
        this.ut.setID(utId);
        if (this.nonce) {
            this.ut.addNonce(doc);
        }
        if (this.created) {
            this.ut.addCreated(this.wssConfig.isPrecisionInMilliSeconds(), doc);
        }
    }

    public void prependToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(this.document, secHeader.getSecurityHeader(), this.ut.getElement(), false);
    }

    public Document build(Document doc, WSSecHeader secHeader) {
        log.debug((Object)"Begin add username token...");
        this.prepare(doc);
        this.prependToHeader(secHeader);
        return doc;
    }
}

