/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.SignatureConfirmation;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;

public class WSSecSignatureConfirmation
extends WSSecBase {
    private static Log log = LogFactory.getLog((String)WSSecSignatureConfirmation.class.getName());
    private SignatureConfirmation sc = null;
    private Document document = null;
    byte[] signatureValue = null;

    public void setSignatureValue(byte[] signatureValue) {
        this.signatureValue = signatureValue;
    }

    public void prepare(Document doc) {
        this.document = doc;
        this.sc = new SignatureConfirmation(doc, this.signatureValue);
        String scId = "SigConf-" + this.sc.hashCode();
        this.sc.setID(scId);
    }

    public void prependToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(this.document, secHeader.getSecurityHeader(), this.sc.getElement(), false);
    }

    public Document build(Document doc, byte[] sigVal, WSSecHeader secHeader) {
        log.debug((Object)"Begin add signature confirmation...");
        this.signatureValue = sigVal;
        this.prepare(doc);
        this.prependToHeader(secHeader);
        return doc;
    }

    public String getId() {
        if (this.sc == null) {
            return null;
        }
        return this.sc.getID();
    }
}

