/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.util.WSSecurityUtil;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecSAMLToken
extends WSSecBase {
    private static Log log = LogFactory.getLog((String)WSSecSAMLToken.class.getName());
    private Document document = null;
    private SAMLAssertion saml = null;

    public void prepare(Document doc, SAMLAssertion assertion) {
        this.document = doc;
        this.saml = assertion;
    }

    public void prependToHeader(WSSecHeader secHeader) {
        Element element = null;
        try {
            element = (Element)this.saml.toDOM(this.document);
        }
        catch (SAMLException ex) {
            throw new RuntimeException(ex.toString());
        }
        WSSecurityUtil.prependChildElement(this.document, secHeader.getSecurityHeader(), element, false);
    }

    public String getId() {
        if (this.saml == null) {
            return null;
        }
        return this.saml.getId();
    }

    public Document build(Document doc, SAMLAssertion assertion, WSSecHeader secHeader) {
        log.debug((Object)"Begin add SAMLAssertion token...");
        this.prepare(doc, assertion);
        this.prependToHeader(secHeader);
        return doc;
    }
}

