/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.action;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureAction
implements Action {
    static Log log = LogFactory.getLog((String)SignatureAction.class.getName());

    public void execute(WSHandler handler, int actionToDo, Document doc, RequestData reqData) throws WSSecurityException {
        String password = handler.getPassword(reqData.getUsername(), actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData).getPassword();
        WSSecSignature wsSign = new WSSecSignature();
        wsSign.setWsConfig(reqData.getWssConfig());
        if (reqData.getSigKeyId() != 0) {
            wsSign.setKeyIdentifierType(reqData.getSigKeyId());
        }
        if (reqData.getSigAlgorithm() != null) {
            wsSign.setSignatureAlgorithm(reqData.getSigAlgorithm());
        }
        wsSign.setUserInfo(reqData.getUsername(), password);
        Element envelope = doc.getDocumentElement();
        Vector requiredParts = reqData.getSignatureParts();
        for (int i = 0; i < requiredParts.size(); ++i) {
            String nmSpace;
            WSEncryptionPart encPart = (WSEncryptionPart)requiredParts.get(i);
            String elemName = encPart.getName();
            Element body = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace = encPart.getNamespace());
            if (body == null) {
                log.debug((Object)("Element " + elemName + " namespaced by " + nmSpace + " is not in the SOAP message and hence signature over this element is ignored"));
                requiredParts.remove(encPart);
                continue;
            }
            log.debug((Object)("Element " + elemName + " namespaced by " + nmSpace + " should be signed"));
        }
        if (reqData.getSignatureParts().size() > 0) {
            wsSign.setParts(reqData.getSignatureParts());
        }
        try {
            wsSign.build(doc, reqData.getSigCrypto(), reqData.getSecHeader());
            reqData.getSignatureValues().add(wsSign.getSignatureValue());
        }
        catch (WSSecurityException e) {
            log.error((Object)"WSSecurityException", (Throwable)e);
            throw new WSSecurityException("WSHandler: Signature: error during message procesing" + e);
        }
    }
}

