/*
 * Decompiled with CFR 0.152.
 */
package org.gridsphere.services.core.utils;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.gridsphere.services.core.user.User;

public class DateUtil {
    public static long unixTimeStampToJavaTime(String timeStamp) {
        if (timeStamp == null || timeStamp.equals("")) {
            return 0L;
        }
        return (long)(Double.parseDouble(timeStamp) * 1000.0);
    }

    public static String getLocalizedDate(PortletRequest request, long milisec) {
        Locale locale = request.getLocale();
        TimeZone tz = DateUtil.getTimeZone(request);
        return DateUtil.getLocalizedDate(locale, tz, milisec, 2, 2);
    }

    public static String getLocalizedDate(PortletRequest request, long milisec, int dateFormat, int timeFormat) {
        Locale locale = request.getLocale();
        TimeZone tz = DateUtil.getTimeZone(request);
        return DateUtil.getLocalizedDate(locale, tz, milisec, dateFormat, timeFormat);
    }

    public static String getLocalizedDate(HttpServletRequest request, long milisec) {
        Locale locale = request.getLocale();
        TimeZone tz = DateUtil.getTimeZone(request);
        return DateUtil.getLocalizedDate(locale, tz, milisec, 2, 2);
    }

    public static String getLocalizedDate(HttpServletRequest request, long milisec, int dateFormat, int timeFormat) {
        Locale locale = request.getLocale();
        TimeZone tz = DateUtil.getTimeZone(request);
        return DateUtil.getLocalizedDate(locale, tz, milisec, dateFormat, timeFormat);
    }

    public static String getLocalizedDate(Locale locale, TimeZone tz, long milisec) {
        return DateUtil.getLocalizedDate(locale, tz, milisec, 2, 2);
    }

    public static String getLocalizedDate(Locale locale, TimeZone tz, long milisec, int dateFormat, int timeFormat) {
        if (milisec == 0L) {
            return "";
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        Calendar cal = Calendar.getInstance(tz, locale);
        cal.setTimeInMillis(milisec);
        DateFormat uformatter = DateFormat.getDateTimeInstance(timeFormat, dateFormat, locale);
        uformatter.setCalendar(cal);
        return uformatter.format(cal.getTime());
    }

    public static TimeZone getTimeZone(PortletRequest request) {
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String tzStr = (String)userInfo.get("gridsphere.user.timezone");
        TimeZone tz = tzStr == null ? TimeZone.getDefault() : TimeZone.getTimeZone(tzStr);
        return tz;
    }

    public static TimeZone getTimeZone(HttpServletRequest request) {
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String tzStr = (String)userInfo.get("gridsphere.user.timezone");
        TimeZone tz = tzStr == null ? TimeZone.getDefault() : TimeZone.getTimeZone(tzStr);
        return tz;
    }

    public static String getLocalizedDate(User user, Locale locale, long milisec, int dateFormat, int timeFormat) {
        String tzStr = (String)user.getAttribute("gridsphere.user.timezone");
        TimeZone tz = tzStr == null ? TimeZone.getDefault() : TimeZone.getTimeZone(tzStr);
        return DateUtil.getLocalizedDate(locale, tz, milisec, dateFormat, timeFormat);
    }

    public static Map getLocalizedTimeZoneNames() {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] availableTZ = TimeZone.getAvailableIDs();
        for (int i = 0; i < availableTZ.length; ++i) {
            if (availableTZ[i].indexOf("/") <= 1 || availableTZ[i].startsWith("System")) continue;
            result.put(availableTZ[i], availableTZ[i]);
        }
        return result;
    }
}

