/*
 * Decompiled with CFR 0.152.
 */
package org.gridsphere.services.core.tomcat;

import java.util.StringTokenizer;
import org.gridsphere.portletcontainer.PortletStatus;

public class TomcatWebAppDescription {
    public static final int UNKNOWN = 0;
    public static final int RUNNING = 1;
    public static final int STOPPED = 2;
    private String contextPath = "";
    private String running = "";
    private int runningState = 0;
    private String sessions = "";
    private String actions = "";
    private String description = "";
    private PortletStatus status = PortletStatus.SUCCESS;
    private String statusMessage = "";

    public TomcatWebAppDescription(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, ":");
        if (tokenizer.countTokens() >= 3) {
            this.contextPath = tokenizer.nextToken();
            this.contextPath = this.contextPath.substring(1);
            if (this.contextPath.equals("")) {
                this.contextPath = "/";
            }
            this.running = tokenizer.nextToken();
            this.sessions = tokenizer.nextToken();
            if (this.running.trim().equalsIgnoreCase("running")) {
                this.runningState = 1;
            }
            if (this.running.trim().equalsIgnoreCase("stopped")) {
                this.runningState = 2;
            }
            this.actions = "start stop reload remove";
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getSessions() {
        return this.sessions;
    }

    public String getRunning() {
        return this.running;
    }

    public int getRunningState() {
        return this.runningState;
    }

    public String getActions() {
        return this.actions;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PortletStatus getStatus() {
        return this.status;
    }

    public void setStatus(PortletStatus status) {
        this.status = status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("contextPath= " + this.contextPath);
        sb.append("\nrunning= " + this.running);
        sb.append("\nrunningState= " + this.runningState);
        sb.append("\nsessions= " + this.sessions);
        sb.append("\nactions= " + this.actions);
        sb.append("\ndescription= " + this.description);
        sb.append("\nstatus= " + this.status);
        sb.append("\nstatus message= " + this.statusMessage);
        return sb.toString();
    }
}

