/*
 * Decompiled with CFR 0.152.
 */
package org.gridsphere.services.core.security.group;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class PortletGroup
implements Serializable,
Cloneable {
    private String oid = null;
    private String name = "";
    private boolean isPublic = true;
    private String description = "";
    private boolean isCore = false;
    private int type = Type.PUBLIC.getType();
    private Set portletRoleList = new HashSet();

    public PortletGroup() {
    }

    public PortletGroup(String groupName) {
        if (groupName == null) {
            this.name = "Unknown Group";
        }
        this.name = groupName;
    }

    public PortletGroup(String groupName, String groupDescription) {
        if (groupName == null) {
            this.name = "Unknown Group";
        }
        this.name = groupName;
        this.description = groupDescription;
    }

    public Set getPortletRoleList() {
        return this.portletRoleList;
    }

    public void setPortletRoleList(Set portletRoleList) {
        this.portletRoleList = portletRoleList;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCore() {
        return this.isCore;
    }

    public void setCore(boolean core) {
        this.isCore = core;
    }

    public boolean getCore() {
        return this.isCore;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        String label = null;
        label = this.name.equals("") ? "" : this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
        return label;
    }

    public String getID() {
        return this.getOid();
    }

    public void setID(String id) {
        this.setOid(id);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            PortletGroup portletGroup = (PortletGroup)object;
            return this.name.equals(portletGroup.getName());
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        PortletGroup s = (PortletGroup)super.clone();
        s.name = this.name;
        return s;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean getPublic() {
        return this.isPublic;
    }

    public void setType(Type type) {
        this.type = type.getType();
    }

    public Type getType() {
        return Type.getType(this.type);
    }

    public void setGroupType(int type) {
        this.type = type;
    }

    public int getGroupType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public static class Type
    implements Serializable,
    Cloneable {
        public static final Type PUBLIC = new Type(1);
        public static final Type PRIVATE = new Type(2);
        public static final Type HIDDEN = new Type(3);
        private String oid = null;
        private int type = 1;

        public Type() {
        }

        public static Type getType(String groupType) {
            if (groupType.toUpperCase().equals("PUBLIC")) {
                return PUBLIC;
            }
            if (groupType.toUpperCase().equals("PRIVATE")) {
                return PRIVATE;
            }
            if (groupType.toUpperCase().equals("HIDDEN")) {
                return HIDDEN;
            }
            throw new IllegalArgumentException("Unknown group type specified: " + groupType);
        }

        public static Type getType(int groupType) {
            if (groupType == 1) {
                return PUBLIC;
            }
            if (groupType == 2) {
                return PRIVATE;
            }
            if (groupType == 3) {
                return HIDDEN;
            }
            throw new IllegalArgumentException("Unknown group type specified: " + groupType);
        }

        private Type(int type) {
            this.type = type;
        }

        public String getOid() {
            return this.oid;
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public Object clone() throws CloneNotSupportedException {
            Type m = (Type)super.clone();
            m.type = this.type;
            return m;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof Type) {
                return this.type == ((Type)o).getType();
            }
            return false;
        }

        public int hashCode() {
            return this.type;
        }

        public String toString() {
            return "" + this.type;
        }

        private Object readResolve() {
            Type m = PUBLIC;
            switch (this.type) {
                case 1: {
                    m = PUBLIC;
                    break;
                }
                case 2: {
                    m = PRIVATE;
                    break;
                }
                case 3: {
                    m = HIDDEN;
                }
            }
            return m;
        }
    }
}

