/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.util.timer;

import java.util.Enumeration;
import java.util.Vector;
import org.globus.cog.util.ConditionVariable;
import org.globus.cog.util.timer.TimerListener;

public class Timer
implements Runnable {
    long durationMillis;
    long startTime;
    long stopTime;
    Vector listeners = new Vector(1);
    ConditionVariable condVar = new ConditionVariable();

    public Timer() {
        this(0L);
    }

    public Timer(long l) {
        this.setDuration(l);
    }

    public void addTimerListener(TimerListener timerListener) {
        this.listeners.add(timerListener);
    }

    public void removeTimerListener(TimerListener timerListener) {
        this.listeners.remove(timerListener);
    }

    private void fireTimerStarted() {
        this.startTime = System.currentTimeMillis();
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((TimerListener)enumeration.nextElement()).timerStarted(this);
        }
    }

    private void fireTimerFinished() {
        this.stopTime = System.currentTimeMillis();
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((TimerListener)enumeration.nextElement()).timerFinished(this);
        }
    }

    public void setDuration(long l) {
        this.durationMillis = l;
    }

    public long getDuration() {
        return this.durationMillis;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public long getElapsedTime() {
        return this.stopTime - this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.fireTimerStarted();
        ConditionVariable conditionVariable = this.condVar;
        synchronized (conditionVariable) {
            try {
                if (this.durationMillis == 0L) {
                    this.condVar.wait();
                } else {
                    this.condVar.wait(this.durationMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Fatal Error: timer interrupted--times invalid");
                return;
            }
        }
        this.fireTimerFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        ConditionVariable conditionVariable = this.condVar;
        synchronized (conditionVariable) {
            this.condVar.setValue(1);
            new Thread(this).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        ConditionVariable conditionVariable = this.condVar;
        synchronized (conditionVariable) {
            if (this.condVar.getValue() == 1) {
                this.condVar.notifyAll();
                this.condVar.setValue(0);
            }
        }
    }
}

