/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.util.timer;

import org.apache.log4j.Logger;

public class StopWatch {
    private static Logger logger = Logger.getLogger((Class)(class$org$globus$cog$util$timer$StopWatch == null ? (class$org$globus$cog$util$timer$StopWatch = StopWatch.class$("org.globus.cog.util.timer.StopWatch")) : class$org$globus$cog$util$timer$StopWatch));
    public static long[] timer;
    public static String[] timerName;
    private long[] startTime;
    private long[] stopTime;
    private long[] pausedTime;
    private long[] storedTime;
    private boolean[] running;
    private int n;
    static /* synthetic */ Class class$org$globus$cog$util$timer$StopWatch;

    public StopWatch(int n) {
        this.init(n);
    }

    public void init(int n) {
        timer = new long[n];
        this.startTime = new long[n];
        this.stopTime = new long[n];
        this.storedTime = new long[n];
        this.running = new boolean[n];
        timerName = new String[n];
        this.n = n;
    }

    public void reset(int n) {
        if (this.running[n]) {
            this.start(n);
        } else {
            logger.warn((Object)("Timer " + n + " (" + timerName[n] + ") is not running."));
        }
    }

    public void set(int n, String string) {
        if (n > this.n) {
            logger.warn((Object)("This time number " + n + " is too big, only " + this.n + " timers allowed"));
        } else {
            StopWatch.timerName[n] = string;
        }
    }

    public int getIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!timerName[i].equals(string)) continue;
            n = i;
        }
        return n;
    }

    public long get(int n) {
        long l = this.running[n] ? System.currentTimeMillis() - this.startTime[n] : this.stopTime[n] - this.startTime[n];
        return l;
    }

    public void add(int n, long l) {
        this.startTime[n] = this.startTime[n] - l;
    }

    public void add(String string, long l) {
        int n = this.getIndex(string);
        this.add(n, l);
    }

    public int size() {
        return this.n;
    }

    public void start(int n) {
        this.startTime[n] = System.currentTimeMillis();
        this.running[n] = true;
    }

    public void stop(int n) {
        this.stopTime[n] = System.currentTimeMillis();
        this.running[n] = false;
    }

    public void pause(int n) {
        this.storedTime[n] = this.get(n) * 1000L;
        this.running[n] = false;
    }

    public void resume(int n) {
        this.start(n);
        this.add(n, this.storedTime[n]);
        this.running[n] = true;
    }

    public void printTimer(int n) {
        System.out.println("Timer " + timerName[n] + "[" + n + "]  : " + this.get(n) + "ms");
    }

    public void printTimer(String string) {
        int n = this.getIndex(string);
        if (n > -1) {
            this.printTimer(n);
        } else {
            logger.warn((Object)("Timer '" + timerName + "' is invalid"));
        }
    }

    public void printTimers() {
        for (int i = 0; i < this.size(); ++i) {
            String string;
            if (this.running[i]) {
                string = "running";
                continue;
            }
            string = "stopped/paused";
            System.out.println("Timer " + timerName[i] + "[" + i + "]  : " + this.get(i) + "ms. Status :" + string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

