/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.util.ntp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class NTPClient {
    private byte[] NTPData;
    private String server;
    private int NTPPort = 123;
    private final byte referenceOffset = (byte)16;
    private final byte originateOffset = (byte)24;
    private final byte receiveOffset = (byte)32;
    private final byte transmitOffset = (byte)40;
    private final byte refIDOffset = (byte)12;
    private byte NTPleap;
    private byte NTPversion;
    private byte NTPmode;
    private byte NTPstratum;
    private byte NTPpoll;
    private byte NTPprecision;
    private long transmitTime;
    private long destinationTimestamp;
    private long referenceTimestamp;
    private long originateTimestamp;
    private long receiveTimestamp;
    private long transmitTimestamp;
    private long localOffset;
    private long roundTripDelay;
    private String refID;
    private long dT1900to1970;

    public NTPClient(String string) {
        this.server = string;
        this.NTPData = new byte[48];
        this.dT1900to1970 = 25550L;
        this.dT1900to1970 += 17L;
        this.dT1900to1970 *= 24L;
        this.dT1900to1970 *= 60L;
        this.dT1900to1970 *= 60L;
        this.dT1900to1970 *= 1000L;
    }

    private void toBytes(long l, int n) {
        long l2 = 0L;
        long l3 = 0L;
        l2 = l / 1000L;
        l3 = l % 1000L / 1000L * 0x100000000L;
        this.NTPData[n + 0] = (byte)(l2 >>> 24 & 0xFFL);
        this.NTPData[n + 1] = (byte)(l2 >>> 16 & 0xFFL);
        this.NTPData[n + 2] = (byte)(l2 >>> 8 & 0xFFL);
        this.NTPData[n + 3] = (byte)(l2 & 0xFFL);
        this.NTPData[n + 4] = (byte)(l3 >>> 24 & 0xFFL);
        this.NTPData[n + 5] = (byte)(l3 >>> 16 & 0xFFL);
        this.NTPData[n + 6] = (byte)(l3 >>> 8 & 0xFFL);
        this.NTPData[n + 7] = (byte)(l3 & 0xFFL);
    }

    private long toLong(int n) {
        long l = ((long)this.NTPData[n + 3] & 0xFFL) + (((long)this.NTPData[n + 2] & 0xFFL) << 8) + (((long)this.NTPData[n + 1] & 0xFFL) << 16) + (((long)this.NTPData[n + 0] & 0xFFL) << 24);
        long l2 = ((long)this.NTPData[n + 7] & 0xFFL) + (((long)this.NTPData[n + 6] & 0xFFL) << 8) + (((long)this.NTPData[n + 5] & 0xFFL) << 16) + (((long)this.NTPData[n + 4] & 0xFFL) << 24);
        long l3 = l * 1000L + l2 * 1000L / 0x100000000L;
        return l3;
    }

    public String getMode() {
        return this.convertMode(this.NTPmode);
    }

    public String convertMode(int n) {
        if (n == 0) {
            return "reserved";
        }
        if (n == 1) {
            return "symmetric active";
        }
        if (n == 2) {
            return "symmetric passive";
        }
        if (n == 3) {
            return "client";
        }
        if (n == 4) {
            return "server";
        }
        if (n == 5) {
            return "broadcast";
        }
        if (n == 6) {
            return "reserved for NTP control message";
        }
        if (n == 7) {
            return "reserved for private use";
        }
        return "ERROR: mode does not exist";
    }

    private void convert() {
        boolean bl = false;
        this.NTPleap = (byte)(this.NTPData[0] >> 6);
        if (this.NTPleap == 3) {
            System.out.println("ERROR: NTP server is unsynchronized");
            bl = true;
        }
        this.NTPversion = (byte)((this.NTPData[0] & 0x38) >> 3);
        this.NTPmode = (byte)(this.NTPData[0] & 7);
        if (this.NTPmode != 4) {
            System.out.println("ERROR: NTP server not in server mode");
            bl = true;
        }
        this.NTPstratum = this.NTPData[1];
        if (this.NTPstratum != 1) {
            System.out.println("ERROR: NTP is not a primary reference");
            bl = true;
        }
        if (!bl) {
            this.NTPpoll = this.NTPData[2];
            this.NTPprecision = this.NTPData[3];
            this.refID = "";
            for (int i = 0; i <= 3; ++i) {
                this.refID = this.refID.concat(String.valueOf((char)this.NTPData[12 + i]));
            }
            this.referenceTimestamp = this.toLong(16);
            this.originateTimestamp = this.toLong(24);
            this.receiveTimestamp = this.toLong(32);
            this.transmitTimestamp = this.toLong(40);
            long l = this.originateTimestamp;
            long l2 = this.receiveTimestamp;
            long l3 = this.transmitTimestamp;
            long l4 = this.destinationTimestamp;
            if (l != this.transmitTime) {
                l = this.transmitTime;
            }
            this.roundTripDelay = l4 - l - (l2 - l3);
            this.localOffset = (l2 - l + (l3 - l4)) / 2L;
        }
    }

    public String getServer() {
        return this.server;
    }

    public String getType() {
        return this.refID;
    }

    public long getDelay() {
        return this.roundTripDelay;
    }

    public long getVariation() {
        return this.localOffset;
    }

    public boolean withinDelta(long l) {
        return Math.abs(this.localOffset - l) <= l;
    }

    public void update() throws IOException {
        this.NTPData[0] = 27;
        for (int i = 1; i < 48; ++i) {
            this.NTPData[i] = 0;
        }
        InetAddress inetAddress = InetAddress.getByName(this.server);
        DatagramSocket datagramSocket = new DatagramSocket();
        DatagramPacket datagramPacket = new DatagramPacket(this.NTPData, this.NTPData.length, inetAddress, this.NTPPort);
        long l = System.currentTimeMillis();
        this.transmitTime = l + this.dT1900to1970;
        this.toBytes(this.transmitTime, 40);
        datagramSocket.send(datagramPacket);
        datagramSocket.receive(datagramPacket);
        this.destinationTimestamp = System.currentTimeMillis();
        this.destinationTimestamp += this.dT1900to1970;
        this.NTPData = datagramPacket.getData();
        this.convert();
        datagramSocket.close();
    }
}

