/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.util.graph;

import java.util.ArrayList;
import java.util.List;
import org.globus.cog.util.graph.Edge;
import org.globus.cog.util.graph.EdgeIterator;
import org.globus.cog.util.graph.EdgeItr;
import org.globus.cog.util.graph.EdgeNotFoundException;

public class Node {
    private Object contents = null;
    private List outEdges;
    private List inEdges;

    public Node() {
    }

    public Node(Object object) {
        this();
        this.setContents(object);
    }

    public Object getContents() {
        return this.contents;
    }

    public void setContents(Object object) {
        this.contents = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInEdge(Edge edge) {
        if (this.inEdges == null) {
            this.inEdges = new ArrayList(1);
        }
        List list = this.inEdges;
        synchronized (list) {
            this.inEdges.add(edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutEdge(Edge edge) {
        if (this.outEdges == null) {
            this.outEdges = new ArrayList(1);
        }
        List list = this.outEdges;
        synchronized (list) {
            this.outEdges.add(edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInEdge(Edge edge) throws EdgeNotFoundException {
        if (this.inEdges == null) {
            throw new EdgeNotFoundException();
        }
        if (this.inEdges.contains(edge)) {
            List list = this.inEdges;
            synchronized (list) {
                this.inEdges.remove(edge);
            }
        } else {
            throw new EdgeNotFoundException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutEdge(Edge edge) throws EdgeNotFoundException {
        if (this.outEdges == null) {
            throw new EdgeNotFoundException();
        }
        if (this.outEdges.contains(edge)) {
            List list = this.outEdges;
            synchronized (list) {
                this.outEdges.remove(edge);
            }
        } else {
            throw new EdgeNotFoundException();
        }
    }

    public void removeEdge(Edge edge) throws EdgeNotFoundException {
        try {
            this.removeInEdge(edge);
            return;
        }
        catch (EdgeNotFoundException edgeNotFoundException) {
            this.removeOutEdge(edge);
            return;
        }
    }

    public int inDegree() {
        if (this.inEdges == null) {
            return 0;
        }
        return this.inEdges.size();
    }

    public int outDegree() {
        if (this.outEdges == null) {
            return 0;
        }
        return this.outEdges.size();
    }

    public int degree() {
        return this.inDegree() + this.outDegree();
    }

    public EdgeIterator getInEdgesIterator() {
        if (this.inEdges == null) {
            return new EdgeItr();
        }
        ((ArrayList)this.inEdges).trimToSize();
        return new EdgeItr(this.inEdges.iterator());
    }

    public EdgeIterator getOutEdgesIterator() {
        if (this.outEdges == null) {
            return new EdgeItr();
        }
        ((ArrayList)this.outEdges).trimToSize();
        return new EdgeItr(this.outEdges.iterator());
    }

    public List getOutEdges() {
        return this.outEdges;
    }

    public List getInEdges() {
        return this.inEdges;
    }
}

