/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.util.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.globus.cog.util.graph.Edge;
import org.globus.cog.util.graph.EdgeIterator;
import org.globus.cog.util.graph.EdgeItr;
import org.globus.cog.util.graph.EdgeNotFoundException;
import org.globus.cog.util.graph.GraphChangedEvent;
import org.globus.cog.util.graph.GraphInterface;
import org.globus.cog.util.graph.GraphListener;
import org.globus.cog.util.graph.Node;
import org.globus.cog.util.graph.NodeIterator;
import org.globus.cog.util.graph.NodeItr;
import org.globus.cog.util.graph.NodeNotFoundException;

public class Graph
implements GraphInterface {
    private Set nodes = new LinkedHashSet();
    private Set edges = new LinkedHashSet();
    private List graphListeners = Collections.synchronizedList(new ArrayList(0));

    public void addGraphListener(GraphListener graphListener) {
        this.graphListeners.add(graphListener);
    }

    public void removeGraphListener(GraphListener graphListener) {
        this.graphListeners.remove(graphListener);
    }

    public void clear() {
        this.edges.clear();
        this.nodes.clear();
    }

    private void fireGraphChangedEvent(GraphChangedEvent graphChangedEvent) {
        ListIterator listIterator = this.graphListeners.listIterator();
        while (listIterator.hasNext()) {
            ((GraphListener)listIterator.next()).graphChanged(graphChangedEvent);
        }
    }

    private void fireGraphChangedEvent(int n, Object object) {
        if (this.graphListeners.size() == 0) {
            return;
        }
        this.fireGraphChangedEvent(new GraphChangedEvent((Object)this, n, object));
    }

    private void fireGraphChangedEvent(int n, Node node) {
        if (this.graphListeners.size() == 0) {
            return;
        }
        this.fireGraphChangedEvent(new GraphChangedEvent((Object)this, n, node));
    }

    private void fireGraphChangedEvent(int n, Edge edge) {
        if (this.graphListeners.size() == 0) {
            return;
        }
        this.fireGraphChangedEvent(new GraphChangedEvent((Object)this, n, edge));
    }

    public Node addNode() {
        Node node = new Node();
        this.nodes.add(node);
        this.fireGraphChangedEvent(0, node);
        return node;
    }

    public Node addNode(Object object) {
        Node node = this.addNode();
        node.setContents(object);
        this.fireGraphChangedEvent(0, node);
        return node;
    }

    public Edge addEdge(Node node, Node node2, Object object) throws NodeNotFoundException {
        this.checkNode(node);
        this.checkNode(node2);
        Edge edge = new Edge(object);
        edge.setNodes(node, node2);
        if (this.edges.contains(edge)) {
            return null;
        }
        node.addOutEdge(edge);
        node2.addInEdge(edge);
        this.edges.add(edge);
        this.fireGraphChangedEvent(1, edge);
        return edge;
    }

    public int edgeCount() {
        return this.edges.size();
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    public NodeIterator getNodesIterator() {
        return new NodeItr(this.nodes.iterator());
    }

    public Set getNodesSet() {
        return this.nodes;
    }

    public EdgeIterator getEdgesIterator() {
        return new EdgeItr(this.edges.iterator());
    }

    public Set getEdgesSet() {
        return this.edges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node node) throws NodeNotFoundException {
        this.checkNode(node);
        Node node2 = node;
        synchronized (node2) {
            Object object;
            EdgeIterator edgeIterator = node.getInEdgesIterator();
            while (edgeIterator.hasNext()) {
                object = (Edge)edgeIterator.next();
                ((Edge)object).getFromNode().removeOutEdge((Edge)object);
                this.edges.remove(object);
                this.fireGraphChangedEvent(new GraphChangedEvent((Object)this, 3, (Edge)object));
            }
            object = node.getOutEdgesIterator();
            while (object.hasNext()) {
                Edge edge = (Edge)object.next();
                edge.getToNode().removeInEdge(edge);
                this.edges.remove(edge);
                this.fireGraphChangedEvent(new GraphChangedEvent((Object)this, 3, edge));
            }
        }
        this.nodes.remove(node);
        this.fireGraphChangedEvent(new GraphChangedEvent((Object)this, 2, node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEdge(Node node, Node node2) throws NodeNotFoundException, EdgeNotFoundException {
        this.checkNode(node);
        this.checkNode(node2);
        Node node3 = node;
        synchronized (node3) {
            EdgeIterator edgeIterator = node.getOutEdgesIterator();
            while (edgeIterator.hasNext()) {
                Edge edge = (Edge)edgeIterator.next();
                if (edge.getToNode() != node2) continue;
                node.removeOutEdge(edge);
                node2.removeInEdge(edge);
                this.edges.remove(edge);
                this.fireGraphChangedEvent(new GraphChangedEvent((Object)this, 3, edge));
                return;
            }
        }
        throw new EdgeNotFoundException();
    }

    public void removeEdge(Edge edge) throws EdgeNotFoundException {
        this.checkEdge(edge);
        edge.getFromNode().removeOutEdge(edge);
        edge.getToNode().removeInEdge(edge);
        this.edges.remove(edge);
        this.fireGraphChangedEvent(new GraphChangedEvent((Object)this, 3, edge));
    }

    private void checkNode(Node node) throws NodeNotFoundException {
        if (!this.nodes.contains(node)) {
            throw new NodeNotFoundException();
        }
    }

    private void checkEdge(Edge edge) throws EdgeNotFoundException {
        if (!this.edges.contains(edge)) {
            throw new EdgeNotFoundException();
        }
    }

    public Edge findEdge(Object object) {
        Iterator iterator = this.edges.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (!edge.getContents().equals(object)) continue;
            return edge;
        }
        return null;
    }

    public Node findNode(Object object) {
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!node.getContents().equals(object)) continue;
            return node;
        }
        return null;
    }

    public Object clone() {
        Object object;
        Graph graph = new Graph();
        Set set = this.getNodesSet();
        NodeIterator nodeIterator = this.getNodesIterator();
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
        Node[] nodeArray = new Node[set.size()];
        int n = 0;
        while (nodeIterator.hasNext()) {
            object = (Node)nodeIterator.next();
            hashtable.put(object, new Integer(n));
            nodeArray[n] = graph.addNode(((Node)object).getContents());
            ++n;
        }
        object = this.getEdgesIterator();
        while (object.hasNext()) {
            Edge edge = (Edge)object.next();
            int n2 = (Integer)hashtable.get(edge.getFromNode());
            int n3 = (Integer)hashtable.get(edge.getToNode());
            graph.addEdge(nodeArray[n2], nodeArray[n3], edge.getContents());
        }
        return graph;
    }

    public boolean equals(Object object) {
        Object object2;
        Object object3;
        if (this == object) {
            return true;
        }
        if (!(object instanceof GraphInterface)) {
            return false;
        }
        GraphInterface graphInterface = (GraphInterface)object;
        if (graphInterface.nodeCount() != this.nodeCount() || graphInterface.edgeCount() != this.edgeCount()) {
            return false;
        }
        Iterator iterator = this.getNodesIterator();
        Iterator iterator2 = graphInterface.getNodesIterator();
        Hashtable<Node, Node> hashtable = new Hashtable<Node, Node>();
        while (iterator.hasNext()) {
            object3 = (Node)iterator.next();
            object2 = (Node)iterator2.next();
            hashtable.put((Node)object3, (Node)object2);
            if (((Node)object3).getContents().equals(((Node)object2).getContents())) continue;
            return false;
        }
        iterator = this.getEdgesIterator();
        iterator2 = graphInterface.getEdgesIterator();
        while (iterator.hasNext()) {
            object3 = (Edge)iterator.next();
            object2 = (Edge)iterator2.next();
            if (!((Edge)object3).getContents().equals(((Edge)object2).getContents())) {
                return false;
            }
            if (hashtable.get(((Edge)object3).getFromNode()) != ((Edge)object2).getFromNode()) {
                return false;
            }
            if (hashtable.get(((Edge)object3).getToNode()) == ((Edge)object2).getToNode()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.getNodesIterator();
        while (iterator.hasNext()) {
            n += ((Node)iterator.next()).getContents().hashCode();
        }
        iterator = this.getEdgesIterator();
        while (iterator.hasNext()) {
            n += ((Edge)iterator.next()).getContents().hashCode();
        }
        return n;
    }
}

