/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.globus.cog.util.TextFileLoader;

public class ImageLoader {
    private static Logger logger = Logger.getLogger((Class)(class$org$globus$cog$util$ImageLoader == null ? (class$org$globus$cog$util$ImageLoader = ImageLoader.class$("org.globus.cog.util.ImageLoader")) : class$org$globus$cog$util$ImageLoader));
    private static Hashtable icons;
    private static ImageIcon nullIcon;
    private static Hashtable imageMappings;
    static /* synthetic */ Class class$org$globus$cog$util$ImageLoader;

    public static void loadMap(String string) {
        TextFileLoader textFileLoader = new TextFileLoader();
        if (!textFileLoader.exists(string)) {
            return;
        }
        String string2 = textFileLoader.loadFromResource(string);
        String[] stringArray = string2.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            if (stringArray2.length != 2) {
                logger.debug((Object)("Invalid line in " + string + ": " + stringArray[i]));
                continue;
            }
            imageMappings.put(stringArray2[0].trim(), stringArray2[1].trim());
        }
    }

    public ImageLoader() {
        if (icons == null) {
            icons = new Hashtable();
        }
    }

    public ImageIcon loadImage(String string) {
        ImageIcon imageIcon = (ImageIcon)icons.get(string);
        if (imageIcon != null) {
            return imageIcon;
        }
        String string2 = (String)imageMappings.get(string);
        if (string2 == null) {
            string2 = string;
            logger.debug((Object)("Loading image " + string));
        } else {
            logger.debug((Object)("Loading image " + string + " (mapped to " + string2 + ")"));
        }
        URL uRL = this.getClass().getClassLoader().getResource(string2);
        if (uRL != null) {
            ImageIcon imageIcon2 = new ImageIcon(uRL);
            icons.put(string, imageIcon2);
            return imageIcon2;
        }
        File file = new File(string);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray, 0, (int)file.length());
            ImageIcon imageIcon3 = new ImageIcon(byArray);
            icons.put(string, imageIcon3);
            return imageIcon3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error((Object)("Image not found: " + string));
            return nullIcon;
        }
        catch (IOException iOException) {
            logger.error((Object)("Error reading from file " + string));
            return nullIcon;
        }
    }

    public static ImageIcon loadIcon(String string) {
        ImageLoader imageLoader = new ImageLoader();
        return imageLoader.loadImage(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nullIcon = new ImageIcon();
        imageMappings = new Hashtable();
        ImageLoader.loadMap("images.map");
    }
}

