/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.globus.cog.util.ArgumentParserException;
import org.globus.cog.util.StringUtil;

public class ArgumentParser {
    public static final int NORMAL = 0;
    public static final int FLAG = 1;
    public static final int OPTIONAL = 2;
    public static final String DEFAULT = null;
    private Map options = new HashMap();
    private Map aliases = new HashMap();
    private Set flags = new HashSet();
    private Map details = new LinkedHashMap();
    private Map argumentNames = new HashMap();
    private Map types = new HashMap();
    private String executableName;

    public void setExecutableName(String string) {
        this.executableName = string;
    }

    public void addFlag(String string, String string2, String string3) {
        this.addOption(string, string2, string3, 3);
    }

    public void addFlag(String string, String string2) {
        this.addOption(string, string2, 3);
    }

    public void addFlag(String string) {
        this.addOption(string, 3);
    }

    public void addOption(String string, String string2, String string3, int n) {
        if (this.options.containsKey(string)) {
            if (string == DEFAULT) {
                throw new RuntimeException("Default argument was already added");
            }
            throw new RuntimeException("Argument " + string + " was already added");
        }
        this.options.put(string, null);
        this.setDetail(string, string2);
        this.setArgumentName(string, string3);
        this.types.put(string, new Integer(n));
    }

    public void addOption(String string, String string2, int n) {
        this.addOption(string, string2, null, n);
    }

    public void addOption(String string, int n) {
        this.addOption(string, null, null, n);
    }

    public void setDetail(String string, String string2) {
        if (!this.options.containsKey(string)) {
            throw new RuntimeException("Trying to set option details for an unexistent option: " + string);
        }
        this.details.put(string, string2);
    }

    public void setArgumentName(String string, String string2) {
        if (!this.options.containsKey(string)) {
            throw new RuntimeException("Trying to set argument name for an unexistent option: " + string);
        }
        this.argumentNames.put(string, string2);
    }

    public void addAlias(String string, String string2) {
        this.aliases.put(string2, string);
    }

    public String getStringValue(String string) {
        return (String)this.options.get(string);
    }

    public String getStringValue(String string, String string2) {
        if (this.hasValue(string)) {
            return this.getStringValue(string);
        }
        return string2;
    }

    public int getIntValue(String string) throws NumberFormatException {
        try {
            return new Integer(this.getStringValue(string));
        }
        catch (Exception exception) {
            throw new NumberFormatException("Invalid numeric value: " + this.getStringValue(string));
        }
    }

    public int getIntValue(String string, int n) throws NumberFormatException {
        if (this.hasValue(string)) {
            return this.getIntValue(string);
        }
        return n;
    }

    public boolean isPresent(String string) {
        return this.flags.contains(string);
    }

    public boolean hasValue(String string) {
        return this.options.get(string) != null;
    }

    protected boolean hasOption(String string, int n) {
        Integer n2 = (Integer)this.types.get(string);
        return (n2 & n) != 0;
    }

    protected boolean isOptional(String string) {
        return this.hasOption(string, 2);
    }

    protected boolean isFlag(String string) {
        return this.hasOption(string, 1);
    }

    protected String getArgumentName(String string) {
        if (this.argumentNames.containsKey(string)) {
            return (String)this.argumentNames.get(string);
        }
        return "value";
    }

    public void parse(String[] stringArray) throws ArgumentParserException {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = string2;
            if (!string3.startsWith("-") && string == null) {
                throw new ArgumentParserException("Invalid argument: " + string3);
            }
            if (string3.startsWith("-") && string == null && this.aliases.containsKey(string3 = string3.substring(1))) {
                string3 = (String)this.aliases.get(string3);
            }
            if (string != null) {
                if (this.isFlag(string)) {
                    throw new ArgumentParserException("Argument '" + string + "' is a flag");
                }
                this.options.put(string, string3);
                string = null;
                continue;
            }
            if (this.options.containsKey(string3)) {
                this.flags.add(string3);
                if (this.isFlag(string3)) {
                    string = null;
                    continue;
                }
                string = string3;
                continue;
            }
            if (i == stringArray.length - 1 && this.options.containsKey(DEFAULT)) {
                this.options.put(DEFAULT, string2);
                continue;
            }
            if (string != null) continue;
            throw new ArgumentParserException("Unknown argument: " + string3);
        }
        if (string != null) {
            throw new ArgumentParserException("Missing value for argument '" + string + "'");
        }
    }

    public void checkMandatory() throws ArgumentParserException {
        Iterator iterator = this.options.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.isOptional(string) || this.isFlag(string) || this.options.get(string) != null) continue;
            throw new ArgumentParserException("Missing mandatory argument " + string);
        }
    }

    protected boolean hasAliases(String string) {
        Iterator iterator = this.aliases.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.equals(this.aliases.get(string2))) continue;
            return true;
        }
        return false;
    }

    public void usage() {
        System.out.println("Usage:");
        if (this.options.containsKey(DEFAULT)) {
            System.out.println("  " + this.executableName + " <options> " + this.getArgumentName(DEFAULT));
        } else {
            System.out.println("  " + this.executableName + " <options> ");
        }
        Iterator iterator = this.details.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            String string3 = "";
            if (string2 == DEFAULT) continue;
            if (this.isOptional(string2)) {
                string3 = string3 + "[";
            }
            if (this.hasAliases(string2)) {
                string3 = string3 + "(";
            }
            string3 = string3 + "-" + string2;
            Iterator iterator2 = this.aliases.keySet().iterator();
            while (iterator2.hasNext()) {
                string = (String)iterator2.next();
                if (!string2.equals(this.aliases.get(string))) continue;
                string3 = string3 + " | -" + string;
            }
            if (this.hasAliases(string2)) {
                string3 = string3 + ")";
            }
            string = (String)this.details.get(string2);
            String string4 = (String)this.argumentNames.get(string2);
            System.out.print("    " + string3);
            if (!this.isFlag(string2)) {
                System.out.print(" <" + this.getArgumentName(string2) + ">");
            }
            if (this.isOptional(string2)) {
                System.out.print("]");
            }
            System.out.println();
            if (string != null) {
                System.out.println(StringUtil.wordWrap(string, 6, 65));
            }
            System.out.println();
        }
    }
}

