/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.gui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JSeparator;
import org.globus.cog.gui.util.HorizontalLayout;

public class VerticalLayout
implements LayoutManager {
    private int border = 2;
    private boolean homogenous;

    public void removeLayoutComponent(Component component) {
    }

    public void layoutContainer(Container container) {
        int n = this.border;
        int n2 = container.getWidth() - 2 * this.border;
        Component[] componentArray = container.getComponents();
        int n3 = 2 * this.border;
        for (int i = 0; i < componentArray.length; ++i) {
            n3 += componentArray[i].getPreferredSize().height;
        }
        double d = 0.0;
        if (this.homogenous) {
            d = (double)container.getHeight() / (double)componentArray.length;
        }
        for (int i = 0; i < componentArray.length; ++i) {
            if (!this.homogenous) {
                d = (double)container.getHeight() / (double)n3 * (double)componentArray[i].getPreferredSize().height;
            }
            if (componentArray[i] instanceof Container && ((Container)componentArray[i]).getLayout() instanceof VerticalLayout || ((Container)componentArray[i]).getLayout() instanceof HorizontalLayout) {
                componentArray[i].setSize(n2, (int)d);
            } else if (componentArray[i] instanceof JSeparator) {
                componentArray[i].setSize(n2, 2);
            } else {
                componentArray[i].setSize(componentArray[i].getPreferredSize());
            }
            double d2 = componentArray[i].getAlignmentX();
            double d3 = componentArray[i].getAlignmentY();
            int n4 = (int)((double)(n2 - componentArray[i].getWidth()) * d2) + this.border;
            componentArray[i].setLocation(n4, n + (int)((d - (double)componentArray[i].getHeight()) * d3));
            n = (int)((double)n + d);
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (n < componentArray[i].getMinimumSize().width) {
                n = componentArray[i].getMinimumSize().width;
            }
            n2 += componentArray[i].getMinimumSize().height;
        }
        return new Dimension(n + 2 * this.border, n2 + 2 * this.border);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Dimension dimension = componentArray[i].getPreferredSize();
            if (n < dimension.width) {
                n = dimension.width;
            }
            n2 += dimension.height;
        }
        return new Dimension(n + 2 * this.border, n2 + 2 * this.border);
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public boolean isHomogenous() {
        return this.homogenous;
    }

    public void setHomogenous(boolean bl) {
        this.homogenous = bl;
    }
}

