/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.gui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Arrays;
import org.globus.cog.gui.util.GridContainer;
import org.globus.cog.gui.util.GridPosition;

public class SimpleGridLayout
implements LayoutManager2 {
    private int hGap = 4;
    private int vGap = 4;
    private int nRows;
    private int nCols;
    private Component[][] grid;
    public static final int Expand = 99999;

    public SimpleGridLayout(int n, int n2) {
        if (n == 0 || n2 == 0) {
            throw new RuntimeException("Invalid grid size for MyGridLayout");
        }
        this.nRows = n;
        this.nCols = n2;
        this.grid = new Component[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.grid[i][j] = null;
            }
        }
    }

    public SimpleGridLayout(int n, int n2, int n3, int n4) {
        this(n, n2);
        this.hGap = n3;
        this.vGap = n4;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof GridPosition) {
            int n = ((GridPosition)object).getRow();
            int n2 = ((GridPosition)object).getCol();
            if (n >= this.nRows || n2 >= this.nCols) {
                this.addLayoutComponent(component, null);
            } else {
                this.grid[n][n2] = component;
            }
        } else {
            block0: for (int i = 0; i < this.nRows; ++i) {
                for (int j = 0; j < this.nCols; ++j) {
                    if (this.grid[i][j] != null) continue;
                    this.grid[i][j] = component;
                    i = this.nRows;
                    continue block0;
                }
            }
        }
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, null);
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        int n3;
        Insets insets = container.getInsets();
        int n4 = insets.left;
        int n5 = insets.top;
        int[] nArray = new int[this.nCols];
        int[] nArray2 = new int[this.nRows];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        Arrays.fill(nArray, 0);
        Arrays.fill(nArray2, 0);
        for (n3 = 0; n3 < this.nRows; ++n3) {
            for (n2 = 0; n2 < this.nCols; ++n2) {
                if (this.grid[n3][n2] == null) continue;
                Dimension dimension = this.grid[n3][n2].getPreferredSize();
                if (dimension == null) {
                    dimension = new Dimension(99999, 99999);
                }
                if (nArray[n2] < dimension.width) {
                    nArray[n2] = dimension.width;
                }
                if (nArray2[n3] >= dimension.height) continue;
                nArray2[n3] = dimension.height;
            }
        }
        n7 += this.hGap * (this.nCols - 1) + insets.left + insets.right;
        n6 += this.vGap * (this.nRows - 1) + insets.top + insets.bottom;
        for (n3 = 0; n3 < this.nRows; ++n3) {
            if (nArray2[n3] != 99999) {
                n6 += nArray2[n3];
                continue;
            }
            ++n9;
        }
        for (n3 = 0; n3 < this.nCols; ++n3) {
            if (nArray[n3] != 99999) {
                n7 += nArray[n3];
                continue;
            }
            ++n8;
        }
        n3 = 1;
        n2 = 1;
        float f = 1.0f;
        float f2 = 1.0f;
        Dimension dimension = container.getSize();
        if (dimension == null) {
            dimension = new Dimension(n7, n6);
        }
        if (n8 != 0) {
            n3 = (dimension.width - n7) / n8;
        } else if (dimension.width != n7) {
            f = (float)dimension.width / (float)n7;
            for (n = 0; n < this.nCols; ++n) {
                nArray[n] = (int)(f * (float)nArray[n]);
            }
        }
        if (n9 != 0) {
            n2 = (dimension.height - n6) / n9;
        } else if (dimension.height != n6) {
            f2 = (float)dimension.height / (float)n6;
            for (n = 0; n < this.nRows; ++n) {
                nArray2[n] = (int)(f2 * (float)nArray2[n]);
            }
        }
        for (n = 0; n < this.nRows; ++n) {
            if (nArray2[n] != 99999) continue;
            nArray2[n] = n2;
        }
        for (n = 0; n < this.nCols; ++n) {
            if (nArray[n] != 99999) continue;
            nArray[n] = n3;
        }
        for (n = 0; n < this.nRows; ++n) {
            for (int i = 0; i < this.nCols; ++i) {
                if (this.grid[n][i] != null) {
                    Component component = this.grid[n][i];
                    Dimension dimension2 = component.getPreferredSize();
                    if (dimension2 == null) {
                        dimension2 = new Dimension(99999, 99999);
                    }
                    int n10 = dimension2.width;
                    int n11 = dimension2.height;
                    if (n10 == 99999) {
                        n10 = n3;
                    }
                    if (n11 == 99999) {
                        n11 = n2;
                    }
                    float f3 = 0.0f;
                    float f4 = 0.0f;
                    if (nArray[i] != 99999) {
                        f3 = nArray[i] - n10;
                    }
                    if (nArray2[n] != 99999) {
                        f4 = nArray2[n] - n11;
                    }
                    int n12 = (int)(f4 * component.getAlignmentY());
                    int n13 = (int)(f3 * component.getAlignmentX());
                    component.setSize(n10, n11);
                    component.setLocation(n4 + n13, n5 + n12);
                }
                n4 += nArray[i] + this.hGap;
                if (i != this.nCols - 1) continue;
                n5 += nArray2[n] + this.vGap;
                n4 = insets.left;
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        int n;
        Insets insets = container.getInsets();
        int n2 = insets.top + insets.bottom;
        int n3 = insets.left + insets.right;
        int[] nArray = new int[this.nCols];
        int[] nArray2 = new int[this.nRows];
        Arrays.fill(nArray, 0);
        Arrays.fill(nArray2, 0);
        for (n = 0; n < this.nRows; ++n) {
            for (int i = 0; i < this.nCols; ++i) {
                if (this.grid[n][i] == null) continue;
                Dimension dimension = this.grid[n][i].getMinimumSize();
                if (nArray[i] < dimension.width) {
                    nArray[i] = dimension.width;
                }
                if (nArray2[n] >= dimension.height) continue;
                nArray2[n] = dimension.height;
            }
        }
        for (n = 0; n < this.nRows; ++n) {
            n2 += nArray2[n];
        }
        n2 += this.vGap * (this.nRows - 1);
        for (n = 0; n < this.nCols; ++n) {
            n3 += nArray[n];
        }
        return new Dimension(n3 += this.hGap * (this.nCols - 1), n2);
    }

    public Dimension preferredLayoutSize(Container container) {
        if (container instanceof GridContainer) {
            return container.getPreferredSize();
        }
        return container.getSize();
    }

    public Dimension preferredLayoutSize1(Container container) {
        int n;
        Insets insets = container.getInsets();
        int n2 = insets.top + insets.bottom;
        int n3 = insets.left + insets.right;
        int[] nArray = new int[this.nCols];
        int[] nArray2 = new int[this.nRows];
        Arrays.fill(nArray, 0);
        Arrays.fill(nArray2, 0);
        for (n = 0; n < this.nRows; ++n) {
            for (int i = 0; i < this.nCols; ++i) {
                if (this.grid[n][i] == null) continue;
                Dimension dimension = this.grid[n][i].getPreferredSize();
                if (nArray[i] < dimension.width) {
                    nArray[i] = dimension.width;
                }
                if (nArray2[n] >= dimension.height) continue;
                nArray2[n] = dimension.height;
            }
        }
        for (n = 0; n < this.nRows; ++n) {
            n2 += nArray2[n];
        }
        n2 += this.vGap * (this.nRows - 1);
        for (n = 0; n < this.nCols; ++n) {
            n3 += nArray[n];
        }
        return new Dimension(n3 += this.hGap * (this.nCols - 1), n2);
    }

    public Dimension maximumLayoutSize(Container container) {
        int n;
        Insets insets = container.getInsets();
        int n2 = insets.top + insets.bottom;
        int n3 = insets.left + insets.right;
        int[] nArray = new int[this.nCols];
        int[] nArray2 = new int[this.nRows];
        Arrays.fill(nArray, 0);
        Arrays.fill(nArray2, 0);
        for (n = 0; n < this.nRows; ++n) {
            for (int i = 0; i < this.nCols; ++i) {
                if (this.grid[n][i] == null) continue;
                Dimension dimension = this.grid[n][i].getMaximumSize();
                if (nArray[i] < dimension.width) {
                    nArray[i] = dimension.width;
                }
                if (nArray2[n] >= dimension.height) continue;
                nArray2[n] = dimension.height;
            }
        }
        for (n = 0; n < this.nRows; ++n) {
            n2 += nArray2[n];
        }
        n2 += this.vGap * (this.nRows - 1);
        for (n = 0; n < this.nCols; ++n) {
            n3 += nArray[n];
        }
        return new Dimension(n3 += this.hGap * (this.nCols - 1), n2);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void removeLayoutComponent(Component component) {
    }

    public void invalidateLayout(Container container) {
    }
}

