/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.globus.cog.gui.util.GridPosition;
import org.globus.cog.gui.util.SimpleGridLayout;
import org.globus.cog.util.HTTPPost;

public class RegistrationPanel
extends JPanel
implements DocumentListener {
    private static final Logger logger = Logger.getLogger((Class)(class$org$globus$cog$gui$util$RegistrationPanel == null ? (class$org$globus$cog$gui$util$RegistrationPanel = RegistrationPanel.class$("org.globus.cog.gui.util.RegistrationPanel")) : class$org$globus$cog$gui$util$RegistrationPanel));
    private static final String DEFAULT_POST_URL = "http://www.cogkit.org/register/register.php";
    private JTextField[] fields;
    private JTextPane description;
    private JCheckBox reregister;
    private static final String[] argnames = new String[]{"firstname", "lastname", "title", "organization", "country", "email", "project", "wwwlink"};
    static /* synthetic */ Class class$org$globus$cog$gui$util$RegistrationPanel;

    public RegistrationPanel() {
        int n;
        this.setLayout(new SimpleGridLayout(3, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new SimpleGridLayout(5, 5));
        this.fields = new JTextField[8];
        for (n = 0; n < 8; ++n) {
            this.fields[n] = new JTextField();
        }
        jPanel.add((Component)new JLabel("First Name:"), new GridPosition(0, 0));
        jPanel.add((Component)this.fields[0], new GridPosition(0, 1));
        jPanel.add((Component)new JLabel("Last Name:"), new GridPosition(0, 3));
        jPanel.add((Component)this.fields[1], new GridPosition(0, 4));
        jPanel.add((Component)new JLabel("Title:"), new GridPosition(1, 0));
        jPanel.add((Component)this.fields[2], new GridPosition(1, 1));
        jPanel.add((Component)new JLabel("Organization:"), new GridPosition(1, 3));
        jPanel.add((Component)this.fields[3], new GridPosition(1, 4));
        jPanel.add((Component)new JLabel("Country:"), new GridPosition(2, 0));
        jPanel.add((Component)this.fields[4], new GridPosition(2, 1));
        jPanel.add((Component)new JLabel("Email:"), new GridPosition(3, 0));
        jPanel.add((Component)this.fields[5], new GridPosition(3, 1));
        jPanel.add((Component)new JLabel("Project Name:"), new GridPosition(4, 0));
        jPanel.add((Component)this.fields[6], new GridPosition(4, 1));
        jPanel.add((Component)new JLabel("Web-Site:"), new GridPosition(4, 3));
        jPanel.add((Component)this.fields[7], new GridPosition(4, 4));
        n = this.fields[0].getPreferredSize().height;
        Dimension dimension = new Dimension(99999, n);
        for (int i = 0; i < 8; ++i) {
            this.fields[i].setPreferredSize(dimension);
            this.fields[i].getDocument().addDocumentListener(this);
        }
        this.add((Component)jPanel, new GridPosition(0, 0));
        jPanel.setPreferredSize(new Dimension(99999, 99999));
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel("Describe your Project and the use of the Java CoG Kit:"), "North");
        this.description = new JTextPane();
        jPanel.add((Component)new JScrollPane(this.description, 22, 32), "Center");
        jPanel.setPreferredSize(new Dimension(99999, 99999));
        this.description.getDocument().addDocumentListener(this);
        this.add((Component)jPanel, new GridPosition(1, 0));
        this.reregister = new JCheckBox("Re-send registration");
        this.add((Component)this.reregister, new GridPosition(2, 0));
        this.loadInfo();
    }

    private void loadInfo() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(System.getProperty("user.home") + File.separator + ".globus" + File.separator + "cogreg.txt"));
            for (int i = 0; i < 8; ++i) {
                this.fields[i].setText(bufferedReader.readLine());
            }
            String string = bufferedReader.readLine();
            StringBuffer stringBuffer = new StringBuffer();
            while (string != null) {
                stringBuffer.append(string);
                string = bufferedReader.readLine();
            }
            this.description.setText(stringBuffer.toString());
            this.reregister.setSelected(false);
            bufferedReader.close();
        }
        catch (Exception exception) {
            this.reregister.setSelected(true);
        }
    }

    public void submit(boolean bl) throws IOException {
        if (this.reregister.isSelected() || bl) {
            Object object;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < 8; ++i) {
                hashMap.put(argnames[i], this.fields[i].getText());
            }
            hashMap.put("description", this.description.getText());
            hashMap.put("version", "Java CoG Kit 4");
            try {
                object = new HTTPPost().post(new URL(DEFAULT_POST_URL), hashMap);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("html=" + (String)object));
                }
                if (((String)object).indexOf("There was a problem") != -1) {
                    throw new IOException("An error was encountered in the registration script");
                }
                this.reregister.setSelected(false);
            }
            catch (MalformedURLException malformedURLException) {
                logger.debug((Object)"Failed to submit results", (Throwable)malformedURLException);
                JOptionPane.showMessageDialog(this, malformedURLException.getMessage(), "Invalid URL", 0);
            }
            try {
                object = new FileWriter(System.getProperty("user.home") + File.separator + ".globus" + File.separator + "cogreg.txt");
                for (int i = 0; i < 8; ++i) {
                    ((Writer)object).write(this.fields[i].getText() + "\n");
                }
                ((Writer)object).write(this.description.getText());
                ((OutputStreamWriter)object).close();
            }
            catch (Exception exception) {
                logger.warn((Object)exception);
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.reregister.isSelected()) {
            this.reregister.doClick();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.reregister.isSelected()) {
            this.reregister.doClick();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (!this.reregister.isSelected()) {
            this.reregister.doClick();
        }
    }

    public JCheckBox getReregister() {
        return this.reregister;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

