/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.globus.cog.gui.util.RegistrationPanel;
import org.globus.cog.gui.util.UITools;

public class RegistrationFrame
extends JFrame
implements ActionListener {
    private RegistrationPanel panel;
    private JButton submit;
    private JButton cancel;
    private boolean done;

    public RegistrationFrame() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JLabel jLabel = new JLabel("Java CoG Kit Registration");
        jLabel.setFont(Font.decode("Arial-bold-18"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 20, 10));
        jPanel.add((Component)jLabel, "North");
        this.panel = new RegistrationPanel();
        this.panel.getReregister().addActionListener(this);
        jPanel.add((Component)this.panel, "Center");
        this.setTitle("Java CoG Kit Registration Form");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        this.submit = new JButton("Submit");
        this.submit.addActionListener(this);
        jPanel2.add(this.submit);
        this.submit.setEnabled(this.panel.getReregister().isSelected());
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        jPanel2.add(this.cancel);
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.submit) {
            try {
                this.panel.submit(false);
                JOptionPane.showMessageDialog(this, "Thank you for registering the Java CoG Kit", "Registration successful", 1);
                this.done();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Could not submit registration information: " + actionEvent.toString(), "Error", 0);
            }
        } else if (actionEvent.getSource() == this.cancel) {
            this.done();
        } else {
            this.submit.setEnabled(this.panel.getReregister().isSelected());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done() {
        this.done = true;
        RegistrationFrame registrationFrame = this;
        synchronized (registrationFrame) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setSize(500, 380);
        UITools.center(null, this);
        this.setVisible(true);
        try {
            RegistrationFrame registrationFrame = this;
            synchronized (registrationFrame) {
                while (!this.done) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(this, "The main thread was interrupted", "Error", 0);
        }
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        RegistrationFrame registrationFrame = new RegistrationFrame();
        registrationFrame.run();
        System.exit(0);
    }
}

