/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.gui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JSeparator;
import org.globus.cog.gui.util.VerticalLayout;

public class HorizontalLayout
implements LayoutManager {
    private int border = 2;
    private boolean homogenous;

    public void removeLayoutComponent(Component component) {
    }

    public void layoutContainer(Container container) {
        int n = this.border;
        int n2 = container.getHeight() - 2 * this.border;
        Component[] componentArray = container.getComponents();
        int n3 = 2 * this.border;
        for (int i = 0; i < componentArray.length; ++i) {
            n3 += componentArray[i].getPreferredSize().width;
        }
        double d = 0.0;
        if (this.homogenous) {
            d = (double)container.getWidth() / (double)componentArray.length;
        }
        for (int i = 0; i < componentArray.length; ++i) {
            if (!this.homogenous) {
                d = (double)container.getWidth() / (double)n3 * (double)componentArray[i].getPreferredSize().width;
            }
            if (componentArray[i] instanceof Container && ((Container)componentArray[i]).getLayout() instanceof VerticalLayout || ((Container)componentArray[i]).getLayout() instanceof HorizontalLayout) {
                componentArray[i].setSize((int)d, n2);
            } else if (componentArray[i] instanceof JSeparator) {
                componentArray[i].setSize(2, n2);
            } else {
                componentArray[i].setSize(componentArray[i].getPreferredSize());
            }
            double d2 = componentArray[i].getAlignmentX();
            double d3 = componentArray[i].getAlignmentY();
            int n4 = (int)((double)(n2 - componentArray[i].getHeight()) * d3) + this.border;
            componentArray[i].setLocation(n + (int)((d - (double)componentArray[i].getWidth()) * d2), n4);
            n = (int)((double)n + d);
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (n < componentArray[i].getMinimumSize().height) {
                n = componentArray[i].getMinimumSize().height;
            }
            n2 += componentArray[i].getMinimumSize().width;
        }
        return new Dimension(n2 + 2 * this.border, n + 2 * this.border);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Dimension dimension = componentArray[i].getPreferredSize();
            if (n < dimension.height) {
                n = dimension.height;
            }
            n2 += dimension.width;
        }
        return new Dimension(n2 + 2 * this.border, n + 2 * this.border);
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public boolean isHomogenous() {
        return this.homogenous;
    }

    public void setHomogenous(boolean bl) {
        this.homogenous = bl;
    }
}

