/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.abstraction.impl.execution.gt2;

import java.util.HashMap;
import java.util.Iterator;
import org.globus.cog.abstraction.impl.execution.gt2.GassServerException;
import org.globus.common.CoGProperties;
import org.globus.io.gass.server.GassServer;
import org.ietf.jgss.GSSCredential;

public class GassServerFactory {
    private static HashMap mapping = new HashMap();
    private static String cogIP = CoGProperties.getDefault().getIPAddress();

    public static GassServer getGassServer(GSSCredential credential) throws GassServerException {
        if (cogIP == null) {
            if (CoGProperties.getDefault().getIPAddress() == null) {
                throw new GassServerException("Could not determine this host's IP address. Please set an IP address in cog.properties");
            }
            cogIP = CoGProperties.getDefault().getIPAddress();
        } else if (!cogIP.equalsIgnoreCase(CoGProperties.getDefault().getIPAddress())) {
            cogIP = CoGProperties.getDefault().getIPAddress();
            GassServerFactory.shutdownGassServers();
        }
        if (mapping.containsKey(credential)) {
            return (GassServer)mapping.get(credential);
        }
        GassServer gassServer = null;
        try {
            gassServer = new GassServer(credential, 0);
        }
        catch (Exception e) {
            throw new GassServerException("Cannot start a gass server", e);
        }
        mapping.put(credential, gassServer);
        return gassServer;
    }

    private static void shutdownGassServers() {
        Iterator iterator = mapping.values().iterator();
        while (iterator.hasNext()) {
            GassServer gs = (GassServer)iterator.next();
            gs.shutdown();
        }
        mapping.clear();
    }
}

