/*
 * Decompiled with CFR 0.152.
 */
package org.globus.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import org.globus.common.ChainedIOException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.net.GSIURLConnection;
import org.globus.util.http.HTTPChunkedInputStream;
import org.globus.util.http.HTTPProtocol;
import org.globus.util.http.HTTPResponseParser;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class GSIHttpURLConnection
extends GSIURLConnection {
    public static final int PORT = 8443;
    private Socket socket;
    private int port;
    private HTTPResponseParser response;
    private InputStream is;

    public GSIHttpURLConnection(URL u) {
        super(u);
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.connected = true;
        this.port = this.url.getPort() == -1 ? 8443 : this.url.getPort();
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = null;
        try {
            context = (ExtendedGSSContext)manager.createContext(this.getExpectedName(), GSSConstants.MECH_OID, this.credentials, 0);
            switch (this.delegationType) {
                case 1: {
                    context.requestCredDeleg(false);
                    break;
                }
                case 2: {
                    context.requestCredDeleg(true);
                    context.setOption(GSSConstants.DELEGATION_TYPE, GSIConstants.DELEGATION_TYPE_LIMITED);
                    break;
                }
                case 3: {
                    context.requestCredDeleg(true);
                    context.setOption(GSSConstants.DELEGATION_TYPE, GSIConstants.DELEGATION_TYPE_FULL);
                    break;
                }
                default: {
                    context.requestCredDeleg(true);
                    context.setOption(GSSConstants.DELEGATION_TYPE, new Integer(this.delegationType));
                }
            }
            if (this.gssMode != null) {
                context.setOption(GSSConstants.GSS_MODE, this.gssMode);
            }
        }
        catch (GSSException e) {
            throw new ChainedIOException("Failed to init GSI context", e);
        }
        GssSocketFactory factory = GssSocketFactory.getDefault();
        this.socket = factory.createSocket(this.url.getHost(), this.port, context);
        ((GssSocket)this.socket).setAuthorization(this.authorization);
    }

    public void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.connect();
            OutputStream out = this.socket.getOutputStream();
            InputStream in = this.socket.getInputStream();
            String msg = HTTPProtocol.createGETHeader(this.url.getFile(), this.url.getHost() + ":" + this.port, "Java-Globus-GASS-HTTP/1.1.0");
            out.write(msg.getBytes());
            out.flush();
            this.response = new HTTPResponseParser(in);
            if (!this.response.isOK()) {
                throw new IOException(this.response.getMessage());
            }
            this.is = this.response.isChunked() ? new HTTPChunkedInputStream(in) : in;
        }
        return this.is;
    }

    public String getHeaderField(String name) {
        if (this.response == null) {
            return null;
        }
        if (name.equalsIgnoreCase("content-type")) {
            return this.response.getContentType();
        }
        if (name.equalsIgnoreCase("content-length")) {
            return String.valueOf(this.response.getContentLength());
        }
        return null;
    }
}

