/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.net;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.ChainedIOException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;

public abstract class GssOutputStream
extends OutputStream {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$gsi$gssapi$net$GssOutputStream == null ? (class$org$globus$gsi$gssapi$net$GssOutputStream = GssOutputStream.class$("org.globus.gsi.gssapi.net.GssOutputStream")) : class$org$globus$gsi$gssapi$net$GssOutputStream).getName());
    protected OutputStream out;
    protected GSSContext context;
    protected byte[] buff;
    protected int index;
    static /* synthetic */ Class class$org$globus$gsi$gssapi$net$GssOutputStream;

    public GssOutputStream(OutputStream out, GSSContext context) {
        this(out, context, 16384);
    }

    public GssOutputStream(OutputStream out, GSSContext context, int size) {
        this.out = out;
        this.context = context;
        this.buff = new byte[size];
        this.index = 0;
    }

    public void write(int b) throws IOException {
        if (this.index == this.buff.length) {
            this.flushData();
        }
        this.buff[this.index++] = (byte)b;
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int off, int len) throws IOException {
        while (len > 0) {
            if (this.index + len > this.buff.length) {
                int max = this.buff.length - this.index;
                System.arraycopy(data, off, this.buff, this.index, max);
                this.index += max;
                this.flushData();
                len -= max;
                off += max;
                continue;
            }
            System.arraycopy(data, off, this.buff, this.index, len);
            this.index += len;
            break;
        }
    }

    protected byte[] wrap() throws IOException {
        try {
            return this.context.wrap(this.buff, 0, this.index, null);
        }
        catch (GSSException e) {
            throw new ChainedIOException("wrap failed", e);
        }
    }

    public abstract void flush() throws IOException;

    private void flushData() throws IOException {
        this.flush();
        this.index = 0;
    }

    public void close() throws IOException {
        logger.debug((Object)"close");
        this.flushData();
        this.out.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

