/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.auth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.globus.gsi.gssapi.auth.GSSAuthorization;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class HostAuthorization
extends GSSAuthorization {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$gsi$gssapi$auth$HostAuthorization == null ? (class$org$globus$gsi$gssapi$auth$HostAuthorization = HostAuthorization.class$("org.globus.gsi.gssapi.auth.HostAuthorization")) : class$org$globus$gsi$gssapi$auth$HostAuthorization).getName());
    public static final HostAuthorization ldapAuthorization = new HostAuthorization("ldap");
    private String _service = null;
    private static HostAuthorization hostAuthorization;
    static /* synthetic */ Class class$org$globus$gsi$gssapi$auth$HostAuthorization;

    public HostAuthorization(String service) {
        this._service = service == null ? "host" : service;
    }

    public static synchronized HostAuthorization getInstance() {
        if (hostAuthorization == null) {
            hostAuthorization = new HostAuthorization("host");
        }
        return hostAuthorization;
    }

    public GSSName getExpectedName(GSSCredential cred, String host) throws GSSException {
        GSSManager manager = ExtendedGSSManager.getInstance();
        return manager.createName(this._service + "@" + host, GSSName.NT_HOSTBASED_SERVICE);
    }

    public void authorize(GSSContext context, String host) throws AuthorizationException {
        logger.debug((Object)"Authorization: HOST");
        try {
            GSSName expected = this.getExpectedName(null, host);
            GSSName target = null;
            target = context.isInitiator() ? context.getTargName() : context.getSrcName();
            if (!expected.equals(target)) {
                this.generateAuthorizationException(expected, target);
            }
        }
        catch (GSSException e) {
            throw new AuthorizationException("Authorization failure", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

